/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.med;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod10Verfahren;
import de.jfachwert.pruefung.NullValidator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016R\u0011\u0010\n\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lde/jfachwert/med/LANR;", "Lde/jfachwert/AbstractFachwert;", "", "code", "validator", "Lde/jfachwert/KSimpleValidator;", "<init>", "(ILde/jfachwert/KSimpleValidator;)V", "", "(Ljava/lang/String;)V", "arztnummer", "getArztnummer", "()I", "pruefziffer", "getPruefziffer", "isZahnarzt", "", "isValid", "fachgruppe", "getFachgruppe", "isPseudoNummer", "()Z", "toString", "Companion", "med"})
public class LANR
extends AbstractFachwert<Integer, LANR> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LengthValidator<Integer> VALIDATOR = new LengthValidator(4, 9);
    @NotNull
    private static final WeakHashMap<Integer, LANR> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final LANR NULL = new LANR(0, (KSimpleValidator<Integer>)((KSimpleValidator)new NullValidator()));
    @JvmField
    @NotNull
    public static final LANR PSEUDO_NUMMER = Companion.of(999999900);
    @JvmField
    @NotNull
    public static final LANR ERSATZWERT_ZAHNARZT = Companion.of(999999991);

    @JvmOverloads
    public LANR(int code, @NotNull KSimpleValidator<Integer> validator) {
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super((Serializable)Integer.valueOf(code), validator);
    }

    public /* synthetic */ LANR(int n, KSimpleValidator kSimpleValidator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            kSimpleValidator = (KSimpleValidator)VALIDATOR;
        }
        this(n, (KSimpleValidator<Integer>)kSimpleValidator);
    }

    public LANR(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(Integer.parseInt(code), null, 2, null);
    }

    public final int getArztnummer() {
        return ((Number)this.getCode()).intValue() / 100;
    }

    public final int getPruefziffer() {
        return ((Number)this.getCode()).intValue() / 100 % 10;
    }

    public boolean isZahnarzt() {
        return this.equals((Object)ERSATZWERT_ZAHNARZT);
    }

    public boolean isValid() {
        Mod10Verfahren mod10Verfahren = new Mod10Verfahren(4, 9);
        String string = Integer.toString(this.getArztnummer());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return mod10Verfahren.isValid(string);
    }

    public final int getFachgruppe() {
        return ((Number)this.getCode()).intValue() % 100;
    }

    public final boolean isPseudoNummer() {
        boolean bl;
        int arztNr = this.getArztnummer();
        switch (arztNr) {
            case 3333333: 
            case 4444444: 
            case 9999999: {
                bl = true;
                break;
            }
            default: {
                bl = arztNr / 10 == 555555;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        String string = "%09d";
        Object[] objectArray = new Object[]{this.getCode()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @JvmOverloads
    public LANR(int code) {
        this(code, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final LANR of(int code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final LANR of(@NotNull String code) {
        return Companion.of(code);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/jfachwert/med/LANR$Companion;", "", "<init>", "()V", "VALIDATOR", "Lde/jfachwert/pruefung/LengthValidator;", "", "getVALIDATOR", "()Lde/jfachwert/pruefung/LengthValidator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/med/LANR;", "NULL", "PSEUDO_NUMMER", "ERSATZWERT_ZAHNARZT", "of", "code", "", "validate", "nummer", "med"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LengthValidator<Integer> getVALIDATOR() {
            return VALIDATOR;
        }

        @JvmStatic
        @NotNull
        public final LANR of(int code) {
            LANR lANR = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$1(Companion::of$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)lANR), (String)"computeIfAbsent(...)");
            return lANR;
        }

        @JvmStatic
        @NotNull
        public final LANR of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return this.of(Integer.parseInt(code));
        }

        public final int validate(int nummer) {
            return ((Number)this.getVALIDATOR().validate((Serializable)Integer.valueOf(nummer))).intValue();
        }

        private static final LANR of$lambda$0(int n) {
            return new LANR(n, null, 2, null);
        }

        private static final LANR of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (LANR)((Object)$tmp0.invoke(p0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

