/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.math.internal.ToNumberSerializer;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@JsonSerialize(using=ToNumberSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002\u00a8\u0006\u0017"}, d2={"Lde/jfachwert/math/AbstractNumber;", "", "", "<init>", "()V", "toBigDecimal", "Ljava/math/BigDecimal;", "toInt", "", "toLong", "", "toFloat", "", "toDouble", "", "toByte", "", "toChar", "", "toShort", "", "compareTo", "other", "math"})
public abstract class AbstractNumber
extends Number
implements Comparable<AbstractNumber> {
    @NotNull
    public abstract BigDecimal toBigDecimal();

    public int toInt() {
        return this.toBigDecimal().intValue();
    }

    public long toLong() {
        return this.toBigDecimal().longValue();
    }

    public float toFloat() {
        return this.toBigDecimal().floatValue();
    }

    public double toDouble() {
        return this.toBigDecimal().doubleValue();
    }

    public byte toByte() {
        return this.toBigDecimal().byteValue();
    }

    public char toChar() {
        return (char)this.intValue();
    }

    public short toShort() {
        return this.toBigDecimal().shortValue();
    }

    @Override
    public int compareTo(@NotNull AbstractNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toBigDecimal().compareTo(other.toBigDecimal());
    }
}

