/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.KFachwert;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000  2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001 B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/jfachwert/math/Primzahl;", "", "Lde/jfachwert/KFachwert;", "", "value", "", "<init>", "(I)V", "toLong", "", "toInt", "toFloat", "", "toDouble", "", "toShort", "", "toByte", "", "toChar", "", "toBigInteger", "Ljava/math/BigInteger;", "next", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "math"})
public class Primzahl
extends Number
implements KFachwert,
Comparable<Primzahl> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    @JvmField
    @NotNull
    public static final Primzahl ZWEI = new Primzahl(2);
    @JvmField
    @NotNull
    public static final Primzahl DREI = new Primzahl(3);
    @NotNull
    private static SoftReference<List<Primzahl>> refPrimzahlen = new SoftReference<List>(de.jfachwert.math.Primzahl$Companion.access$initPrimzahlen(Companion));

    private Primzahl(int value) {
        this.value = value;
    }

    public long toLong() {
        return this.value;
    }

    public int toInt() {
        return this.value;
    }

    public float toFloat() {
        return this.toBigInteger().floatValue();
    }

    public double toDouble() {
        return this.toBigInteger().doubleValue();
    }

    public short toShort() {
        return this.toBigInteger().shortValue();
    }

    public byte toByte() {
        return this.toBigInteger().byteValue();
    }

    public char toChar() {
        return (char)this.intValue();
    }

    @NotNull
    public final BigInteger toBigInteger() {
        BigInteger bigInteger = BigInteger.valueOf(this.longValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        return bigInteger;
    }

    @NotNull
    public final Primzahl next() {
        return Companion.after(this.intValue());
    }

    @Override
    public int compareTo(@NotNull Primzahl other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value - other.value;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        Primzahl primzahl = (Primzahl)other;
        return this.value == primzahl.value;
    }

    public int hashCode() {
        return this.value;
    }

    @NotNull
    public String toString() {
        String string = Integer.toString(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Primzahl after(int zahl) {
        return Companion.after(zahl);
    }

    public /* synthetic */ Primzahl(int value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005 \n*\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t0\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/math/Primzahl$Companion;", "", "<init>", "()V", "ZWEI", "Lde/jfachwert/math/Primzahl;", "DREI", "refPrimzahlen", "Ljava/lang/ref/SoftReference;", "", "kotlin.jvm.PlatformType", "initPrimzahlen", "first", "after", "zahl", "", "hasTeiler", "", "n", "primzahlen", "getPrimzahlen", "()Ljava/util/List;", "math"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Primzahl> initPrimzahlen() {
            List primzahlen = new CopyOnWriteArrayList();
            primzahlen.add(DREI);
            return primzahlen;
        }

        @NotNull
        public final Primzahl first() {
            return ZWEI;
        }

        @JvmStatic
        @NotNull
        public final Primzahl after(int zahl) {
            List<Primzahl> primzahlen = this.getPrimzahlen();
            for (Primzahl p : primzahlen) {
                if (zahl >= p.intValue()) continue;
                return p;
            }
            Companion $this$after_u24lambda_u240 = this;
            boolean bl = false;
            for (int n = primzahlen.get(primzahlen.size() - 1).intValue() + 2; n <= zahl; n += 2) {
                if ($this$after_u24lambda_u240.hasTeiler(n)) continue;
                primzahlen.add(new Primzahl(n, null));
            }
            int n = primzahlen.get(primzahlen.size() - 1).intValue() + 2;
            while (this.hasTeiler(n)) {
                n += 2;
            }
            Primzahl nextPrimzahl = new Primzahl(n, null);
            primzahlen.add(nextPrimzahl);
            return nextPrimzahl;
        }

        private final boolean hasTeiler(int n) {
            for (Primzahl p : this.getPrimzahlen()) {
                int teiler = p.intValue();
                if (n % teiler == 0) {
                    return true;
                }
                if (teiler * teiler <= n) continue;
                break;
            }
            return false;
        }

        private final List<Primzahl> getPrimzahlen() {
            List<Primzahl> primzahlen = (List<Primzahl>)refPrimzahlen.get();
            if (primzahlen == null) {
                primzahlen = this.initPrimzahlen();
                refPrimzahlen = new SoftReference<List<Primzahl>>(primzahlen);
            }
            return primzahlen;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ List access$initPrimzahlen(Companion $this) {
            return $this.initPrimzahlen();
        }
    }
}

