/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.formular;

import de.jfachwert.KFachwert;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u0000 \u00162\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0016B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0017"}, d2={"Lde/jfachwert/formular/Familienstand;", "Lde/jfachwert/KFachwert;", "", "schluessel", "", "text", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getSchluessel", "()Ljava/lang/String;", "LEDIG", "VERHEIRATET", "VERWITWET", "GESCHIEDEN", "EHE_AUFGEHOBEN", "EINGETRAGENE_LEBENSPARTNERSCHAFT", "EHEAEHNLICHE_GEMEINSCHAFT", "DURCH_TOD_AUFGELOESTE_LEBENSPARTNERSCHAFT", "AUFGEHOBENE_LEBENSPARTNERSCHAFT", "DURCH_TODESERKLAERUNG_AUFGELOESTE_LEBENSPARTNERSCHAFT", "NICHT_BEKANNT", "toString", "Companion", "formular"})
public final class Familienstand
extends Enum<Familienstand>
implements KFachwert {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String schluessel;
    @NotNull
    private final String text;
    public static final /* enum */ Familienstand LEDIG;
    public static final /* enum */ Familienstand VERHEIRATET;
    public static final /* enum */ Familienstand VERWITWET;
    public static final /* enum */ Familienstand GESCHIEDEN;
    public static final /* enum */ Familienstand EHE_AUFGEHOBEN;
    public static final /* enum */ Familienstand EINGETRAGENE_LEBENSPARTNERSCHAFT;
    public static final /* enum */ Familienstand EHEAEHNLICHE_GEMEINSCHAFT;
    public static final /* enum */ Familienstand DURCH_TOD_AUFGELOESTE_LEBENSPARTNERSCHAFT;
    public static final /* enum */ Familienstand AUFGEHOBENE_LEBENSPARTNERSCHAFT;
    public static final /* enum */ Familienstand DURCH_TODESERKLAERUNG_AUFGELOESTE_LEBENSPARTNERSCHAFT;
    public static final /* enum */ Familienstand NICHT_BEKANNT;
    private static final /* synthetic */ Familienstand[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Familienstand(String schluessel, String text) {
        this.schluessel = schluessel;
        this.text = text;
    }

    @NotNull
    public final String getSchluessel() {
        return this.schluessel;
    }

    @NotNull
    public String toString() {
        return this.text;
    }

    public static Familienstand[] values() {
        return (Familienstand[])$VALUES.clone();
    }

    public static Familienstand valueOf(String value) {
        return Enum.valueOf(Familienstand.class, value);
    }

    @NotNull
    public static EnumEntries<Familienstand> getEntries() {
        return $ENTRIES;
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Familienstand of(@NotNull String schluessel) {
        return Companion.of(schluessel);
    }

    static {
        LEDIG = new Familienstand("LD", "ledig");
        VERHEIRATET = new Familienstand("VH", "verheiratet");
        VERWITWET = new Familienstand("VW", "verwitwet");
        GESCHIEDEN = new Familienstand("GS", "geschieden");
        EHE_AUFGEHOBEN = new Familienstand("EA", "Ehe aufgehoben");
        EINGETRAGENE_LEBENSPARTNERSCHAFT = new Familienstand("LP", "eingetragene Lebenspartnerschaft");
        EHEAEHNLICHE_GEMEINSCHAFT = new Familienstand("EG", "ehe\u00e4hnliche Gemeinschaft");
        DURCH_TOD_AUFGELOESTE_LEBENSPARTNERSCHAFT = new Familienstand("LV", "durch Tod aufgel\u00f6ste Lebenspartnerschaft");
        AUFGEHOBENE_LEBENSPARTNERSCHAFT = new Familienstand("LA", "getrennt lebend");
        DURCH_TODESERKLAERUNG_AUFGELOESTE_LEBENSPARTNERSCHAFT = new Familienstand("LE", "durch Todeserkl\u00e4rung aufgel\u00f6ste Lebenspartnerschaft");
        NICHT_BEKANNT = new Familienstand("NB", "nicht bekannt");
        $VALUES = familienstandArray = new Familienstand[]{Familienstand.LEDIG, Familienstand.VERHEIRATET, Familienstand.VERWITWET, Familienstand.GESCHIEDEN, Familienstand.EHE_AUFGEHOBEN, Familienstand.EINGETRAGENE_LEBENSPARTNERSCHAFT, Familienstand.EHEAEHNLICHE_GEMEINSCHAFT, Familienstand.DURCH_TOD_AUFGELOESTE_LEBENSPARTNERSCHAFT, Familienstand.AUFGEHOBENE_LEBENSPARTNERSCHAFT, Familienstand.DURCH_TODESERKLAERUNG_AUFGELOESTE_LEBENSPARTNERSCHAFT, Familienstand.NICHT_BEKANNT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lde/jfachwert/formular/Familienstand$Companion;", "", "<init>", "()V", "of", "Lde/jfachwert/formular/Familienstand;", "schluessel", "", "findSchluessel", "findText", "text", "formular"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Familienstand of(@NotNull String schluessel) {
            Familienstand familienstand;
            Intrinsics.checkNotNullParameter((Object)schluessel, (String)"schluessel");
            String normalized = StringUtils.trimToEmpty((String)schluessel);
            if (normalized.length() == 2) {
                Intrinsics.checkNotNull((Object)normalized);
                familienstand = this.findSchluessel(normalized);
            } else {
                Intrinsics.checkNotNull((Object)normalized);
                familienstand = this.findText(normalized);
            }
            return familienstand;
        }

        private final Familienstand findSchluessel(String schluessel) {
            for (Familienstand familienstand : Familienstand.values()) {
                if (!StringsKt.equals((String)familienstand.getSchluessel(), (String)schluessel, (boolean)true)) continue;
                return familienstand;
            }
            return NICHT_BEKANNT;
        }

        private final Familienstand findText(String text) {
            for (Familienstand familienstand : Familienstand.values()) {
                if (!StringsKt.equals((String)familienstand.text, (String)text, (boolean)true)) continue;
                return familienstand;
            }
            return NICHT_BEKANNT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

