/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.pruefung.NoopVerfahren;
import de.jfachwert.pruefung.exception.InvalidLengthException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.io.Serializable;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 \u0010*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0010B\u001b\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/jfachwert/pruefung/LengthValidator;", "T", "Ljava/io/Serializable;", "Lde/jfachwert/pruefung/NoopVerfahren;", "min", "", "max", "<init>", "(II)V", "isValid", "", "wert", "(Ljava/io/Serializable;)Z", "validate", "value", "(Ljava/io/Serializable;)Ljava/io/Serializable;", "Companion", "core"})
public class LengthValidator<T extends Serializable>
extends NoopVerfahren<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int min;
    private final int max;
    @NotNull
    private static final PruefzifferVerfahren<String> NOT_EMPTY_VALIDATOR = new LengthValidator(1, 0, 2, null);

    @JvmOverloads
    public LengthValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public /* synthetic */ LengthValidator(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        this(n, n2);
    }

    @Override
    public boolean isValid(@NotNull T wert) {
        Intrinsics.checkNotNullParameter(wert, (String)"wert");
        int length = Objects.toString(wert, "").length();
        return length >= this.min && length <= this.max;
    }

    @Override
    @NotNull
    public T validate(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!this.isValid(value)) {
            String string = Objects.toString(value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new InvalidLengthException(string, this.min, this.max);
        }
        return value;
    }

    @JvmOverloads
    public LengthValidator(int min) {
        this(min, 0, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/pruefung/LengthValidator$Companion;", "", "<init>", "()V", "NOT_EMPTY_VALIDATOR", "Lde/jfachwert/PruefzifferVerfahren;", "", "getNOT_EMPTY_VALIDATOR", "()Lde/jfachwert/PruefzifferVerfahren;", "validate", "value", "expected", "", "min", "max", "verify", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PruefzifferVerfahren<String> getNOT_EMPTY_VALIDATOR() {
            return NOT_EMPTY_VALIDATOR;
        }

        @NotNull
        public final String validate(@NotNull String value, int expected) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value.length() != expected) {
                throw new InvalidLengthException(value, expected);
            }
            return value;
        }

        @NotNull
        public final String validate(@NotNull String value, int min, int max) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (min == max) {
                return this.validate(value, min);
            }
            if (value.length() < min || value.length() > max) {
                throw new InvalidLengthException(value, min, max);
            }
            return value;
        }

        @NotNull
        public final String verify(@NotNull String value, int min, int max) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                string = this.validate(value, min, max);
            }
            catch (IllegalArgumentException ex) {
                throw new LocalizedIllegalArgumentException(ex);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

