/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.pruefung.exception.LocalizedValidationException;
import de.jfachwert.pruefung.exception.ValidationException;
import de.jfachwert.util.SmallUUID;
import de.jfachwert.util.TinyUUID;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0011J'\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J/\u0010\u0012\u001a\u00020\b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001bJ/\u0010\u001a\u001a\u00020\n2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/jfachwert/FachwertFactory;", "", "<init>", "()V", "registeredClasses", "", "", "Ljava/lang/Class;", "Lde/jfachwert/KFachwert;", "register", "", "fachwertClass", "classname", "logIgnoredRegistration", "ex", "", "getRegisteredClasses", "", "getFachwert", "name", "args", "", "Ljava/io/Serializable;", "(Ljava/lang/String;[Ljava/io/Serializable;)Lde/jfachwert/KFachwert;", "clazz", "(Ljava/lang/Class;[Ljava/io/Serializable;)Lde/jfachwert/KFachwert;", "validate", "(Ljava/lang/String;[Ljava/io/Serializable;)V", "(Ljava/lang/Class;[Ljava/io/Serializable;)V", "getClassFor", "getSimilarName", "Companion", "core"})
public final class FachwertFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Class<? extends KFachwert>> registeredClasses = new HashMap();
    private static final Logger log = Logger.getLogger(KFachwert.class.getName());
    @NotNull
    private static final FachwertFactory instance = new FachwertFactory();

    private FachwertFactory() {
    }

    public final synchronized void register(@NotNull Class<? extends KFachwert> fachwertClass) {
        Intrinsics.checkNotNullParameter(fachwertClass, (String)"fachwertClass");
        try {
            this.registeredClasses.put(fachwertClass.getSimpleName(), fachwertClass);
        }
        catch (NoClassDefFoundError ex) {
            this.logIgnoredRegistration(fachwertClass, ex);
        }
    }

    public final void register(@NotNull String classname) {
        Intrinsics.checkNotNullParameter((Object)classname, (String)"classname");
        try {
            Class<?> clazz = Class.forName(classname);
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out de.jfachwert.KFachwert>");
            Class<?> fachwertClass = clazz;
            this.register(fachwertClass);
        }
        catch (ClassNotFoundException ex) {
            this.logIgnoredRegistration(classname, ex);
        }
        catch (NoClassDefFoundError ex) {
            this.logIgnoredRegistration(classname, ex);
        }
    }

    private final void logIgnoredRegistration(Object fachwertClass, Throwable ex) {
        log.log(Level.FINE, "Registrierung von " + fachwertClass + " wird ignoriert.");
        log.log(Level.FINER, "Details:", ex);
    }

    @NotNull
    public final Map<String, Class<? extends KFachwert>> getRegisteredClasses() {
        return this.registeredClasses;
    }

    @NotNull
    public final KFachwert getFachwert(@NotNull String name, Serializable ... args) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Class<? extends KFachwert> fachwertClass = this.getClassFor(name);
        return this.getFachwert(fachwertClass, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final KFachwert getFachwert(@NotNull Class<? extends KFachwert> clazz, Serializable ... args) {
        KFachwert kFachwert;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Class[] argTypes = FachwertFactory.Companion.toTypes(args);
        try {
            Constructor<? extends KFachwert> ctor = clazz.getConstructor(Arrays.copyOf(argTypes, argTypes.length));
            kFachwert = ctor.newInstance(Arrays.copyOf(args, args.length));
        }
        catch (ReflectiveOperationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ValidationException) {
                throw (ValidationException)cause;
            }
            if (cause instanceof IllegalArgumentException) {
                throw new LocalizedValidationException(((IllegalArgumentException)cause).getMessage(), cause);
            }
            throw new IllegalArgumentException("cannot create " + clazz + " with " + Arrays.toString(args), ex);
        }
        return kFachwert;
    }

    public final void validate(@NotNull String name, Serializable ... args) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Class<? extends KFachwert> fachwertClass = this.getClassFor(name);
        this.validate(fachwertClass, Arrays.copyOf(args, args.length));
    }

    public final void validate(@NotNull Class<? extends KFachwert> clazz, Serializable ... args) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Optional validator = FachwertFactory.Companion.getValidator(clazz);
        if (validator.isPresent()) {
            ((KSimpleValidator)validator.get()).validateObject(args[0]);
        } else {
            FachwertFactory.Companion.callValidate(clazz, args);
        }
    }

    private final Class<? extends KFachwert> getClassFor(String name) {
        Class<? extends KFachwert> fachwertClass = this.registeredClasses.get(name);
        if (fachwertClass == null) {
            fachwertClass = this.registeredClasses.get(this.getSimilarName(name));
        }
        Class<? extends KFachwert> clazz = fachwertClass;
        Intrinsics.checkNotNull(clazz);
        return clazz;
    }

    private final String getSimilarName(String name) {
        String similarName = "?";
        int minDistance = Integer.MAX_VALUE;
        for (String registeredName : this.registeredClasses.keySet()) {
            int dist = FachwertFactory.Companion.distance(name, registeredName);
            if (dist >= minDistance) continue;
            similarName = registeredName;
            minDistance = dist;
        }
        if (minDistance > 2) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Nearest name for '" + name + "' is '" + similarName + "' and too far away (" + minDistance + ") - will use Text class as fallback.");
            }
            similarName = Text.class.getSimpleName();
        }
        return similarName;
    }

    @NotNull
    public static final FachwertFactory getInstance() {
        return Companion.getInstance();
    }

    static {
        instance.register(Text.class);
        instance.register(TinyUUID.class);
        instance.register(SmallUUID.class);
        instance.register("de.jfachwert.bank.Bankverbindung");
        instance.register("de.jfachwert.bank.BIC");
        instance.register("de.jfachwert.bank.BLZ");
        instance.register("de.jfachwert.bank.IBAN");
        instance.register("de.jfachwert.bank.Kontonummer");
        instance.register("de.jfachwert.bank.Zinssatz");
        instance.register("de.jfachwert.formular.Anrede");
        instance.register("de.jfachwert.formular.Familienstand");
        instance.register("de.jfachwert.formular.Geschlecht");
        instance.register("de.jfachwert.math.Bruch");
        instance.register("de.jfachwert.math.Nummer");
        instance.register("de.jfachwert.math.PackedDecimal");
        instance.register("de.jfachwert.math.Prozent");
        instance.register("de.jfachwert.math.Promille");
        instance.register("de.jfachwert.money.Geldbetrag");
        instance.register("de.jfachwert.money.Waehrung");
        instance.register("de.jfachwert.med.BSNR");
        instance.register("de.jfachwert.med.Hilfsmittelnummer");
        instance.register("de.jfachwert.med.IK");
        instance.register("de.jfachwert.med.LANR");
        instance.register("de.jfachwert.med.PZN");
        instance.register("de.jfachwert.med.SNOMED");
        instance.register("de.jfachwert.med.Versichertennummer");
        instance.register("de.jfachwert.med.ZANR");
        instance.register("de.jfachwert.net.ChatAccount");
        instance.register("de.jfachwert.net.Domainname");
        instance.register("de.jfachwert.net.EMailAdresse");
        instance.register("de.jfachwert.net.Telefonnummer");
        instance.register("de.jfachwert.steuer.Mehrwertsteuer");
        instance.register("de.jfachwert.steuer.SteuerIdNr");
        instance.register("de.jfachwert.steuer.Steuernummer");
        instance.register("de.jfachwert.steuer.UStIdNr");
        instance.register("de.jfachwert.post.Adressat");
        instance.register("de.jfachwert.post.Adresse");
        instance.register("de.jfachwert.post.Anschrift");
        instance.register("de.jfachwert.post.Name");
        instance.register("de.jfachwert.post.Ort");
        instance.register("de.jfachwert.post.PLZ");
        instance.register("de.jfachwert.post.Postfach");
        instance.register("de.jfachwert.rechnung.Artikelnummer");
        instance.register("de.jfachwert.rechnung.Bestellnummer");
        instance.register("de.jfachwert.rechnung.Kundennummer");
        instance.register("de.jfachwert.rechnung.Rechnungsmonat");
        instance.register("de.jfachwert.rechnung.Rechnungsnummer");
        instance.register("de.jfachwert.rechnung.Referenznummer");
        instance.register("de.jfachwert.zeit.Zeitdauer");
        instance.register("de.jfachwert.zeit.Zeitpunkt");
        instance.register("de.jfachwert.zeit.Zeitraum");
        instance.register("de.jfachwert.zeit.Zeiteinheit");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J+\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0013\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00012\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0002J)\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00162\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lde/jfachwert/FachwertFactory$Companion;", "", "<init>", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "instance", "Lde/jfachwert/FachwertFactory;", "getInstance$annotations", "getInstance", "()Lde/jfachwert/FachwertFactory;", "getValidator", "Ljava/util/Optional;", "Lde/jfachwert/KSimpleValidator;", "clazz", "Ljava/lang/Class;", "Lde/jfachwert/KFachwert;", "callValidate", "", "args", "", "Ljava/io/Serializable;", "(Ljava/lang/Class;[Ljava/io/Serializable;)V", "obj", "(Ljava/lang/Object;[Ljava/io/Serializable;Ljava/lang/Class;)V", "getCompanionOf", "toTypes", "([Ljava/io/Serializable;)[Ljava/lang/Class;", "distance", "", "a", "", "b", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FachwertFactory getInstance() {
            return instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final Optional<KSimpleValidator<?>> getValidator(Class<? extends KFachwert> clazz) {
            try {
                Class<? extends KFachwert> clazz2 = clazz;
                Intrinsics.checkNotNull(clazz2);
                Field validatorField = clazz2.getDeclaredField("VALIDATOR");
                validatorField.setAccessible(true);
                Object obj = validatorField.get(null);
                if (obj instanceof KSimpleValidator) {
                    Optional<Object> optional = Optional.of(obj);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return optional;
                }
            }
            catch (ReflectiveOperationException ex) {
                log.log(Level.FINE, "Kann nicht auf den Validator in " + clazz + " zugreifen.");
                log.log(Level.FINER, "Details:", ex);
            }
            Optional<KSimpleValidator<?>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }

        private final void callValidate(Class<? extends KFachwert> clazz, Serializable[] args) {
            try {
                Object companion = this.getCompanionOf(clazz);
                Class<?> clazz2 = companion.getClass();
                Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<out de.jfachwert.KFachwert>");
                this.callValidate(companion, args, clazz2);
            }
            catch (ReflectiveOperationException ex) {
                log.log(Level.FINE, "Kann nicht Companion von " + clazz + " verwenden.");
                log.log(Level.FINER, "Details:", ex);
                try {
                    this.callValidate(null, args, clazz);
                }
                catch (ReflectiveOperationException rex) {
                    log.log(Level.FINE, "Kann die validate-Methode von " + clazz + " nicht aufrufen.");
                    log.log(Level.FINER, "Details:", rex);
                }
            }
        }

        private final void callValidate(Object obj, Serializable[] args, Class<? extends KFachwert> clazz) throws ReflectiveOperationException {
            try {
                Class<?>[] argTypes = this.toTypes(args);
                Method method = clazz.getMethod("validate", Arrays.copyOf(argTypes, argTypes.length));
                method.invoke(obj, (Object[])Arrays.copyOf(args, args.length));
            }
            catch (InvocationTargetException ex) {
                log.log(Level.FINE, "Aufruf der validate-Methode von " + clazz + " funktioniert nicht.");
                if (ex.getTargetException() instanceof ValidationException) {
                    Throwable throwable = ex.getTargetException();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type de.jfachwert.pruefung.exception.ValidationException");
                    throw (ValidationException)throwable;
                }
                log.log(Level.FINER, "Details:", ex);
            }
        }

        private final Object getCompanionOf(Class<? extends KFachwert> clazz) throws ReflectiveOperationException {
            Field companionField = clazz.getField("Companion");
            Object object = companionField.get(null);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return object;
        }

        private final Class<?>[] toTypes(Serializable[] args) {
            Class[] argTypes = new Class[args.length];
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                argTypes[i] = args[i].getClass();
            }
            return argTypes;
        }

        private final int distance(String a, String b) {
            return new Text(a, null, 2, null).getDistanz(b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

