/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.util;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\b\u0016\u0018\u0000 \u001c2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0006\u0010\u001b\u001a\u00020\u0006R\u0011\u0010\u0010\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lde/jfachwert/util/TinyUUID;", "Lde/jfachwert/AbstractFachwert;", "Ljava/util/UUID;", "uuid", "<init>", "(Ljava/util/UUID;)V", "", "(Ljava/lang/String;)V", "number", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "bytes", "", "([B)V", "toNumber", "toBytes", "uUID", "getUUID", "()Ljava/util/UUID;", "leastSignificantBits", "", "getLeastSignificantBits", "()J", "mostSignificantBits", "getMostSignificantBits", "toString", "toShortString", "toLongString", "Companion", "core"})
public class TinyUUID
extends AbstractFachwert<UUID, TinyUUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final TinyUUID MIN = new TinyUUID("00000000-0000-0000-0000-000000000000");
    @JvmField
    @NotNull
    public static final TinyUUID MAX = new TinyUUID("ffffffff-ffff-ffff-ffff-ffffffffffff");

    public TinyUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(uuid, null, 2, null);
    }

    public TinyUUID(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this(TinyUUID.Companion.toUUID(uuid));
    }

    public TinyUUID(@NotNull BigInteger number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this(TinyUUID.Companion.toUUID(number));
    }

    public TinyUUID(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this(TinyUUID.Companion.toUUID(bytes));
    }

    @NotNull
    public final BigInteger toNumber() {
        UUID uuid = (UUID)this.getCode();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return TinyUUID.Companion.toBigInteger(string);
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] bytes = this.toNumber().toByteArray();
        Intrinsics.checkNotNull((Object)bytes);
        return TinyUUID.Companion.to16Bytes(bytes);
    }

    @NotNull
    public final UUID getUUID() {
        return (UUID)this.getCode();
    }

    public final long getLeastSignificantBits() {
        return this.getUUID().getLeastSignificantBits();
    }

    public final long getMostSignificantBits() {
        return this.getUUID().getMostSignificantBits();
    }

    @Override
    @NotNull
    public String toString() {
        return this.toShortString();
    }

    @NotNull
    public String toShortString() {
        String s = Base64.getEncoder().withoutPadding().encodeToString(this.toBytes());
        Intrinsics.checkNotNull((Object)s);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)s, (char)'/', (char)'_', (boolean)false, (int)4, null), (char)'+', (char)'-', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String toLongString() {
        String string = this.getUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final TinyUUID fromString(@NotNull String id) {
        return Companion.fromString(id);
    }

    @JvmStatic
    @NotNull
    public static final TinyUUID randomUUID() {
        return Companion.randomUUID();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000eH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/util/TinyUUID$Companion;", "", "<init>", "()V", "MIN", "Lde/jfachwert/util/TinyUUID;", "MAX", "to16Bytes", "", "number", "Ljava/math/BigInteger;", "bytes", "toBigInteger", "uuid", "", "toString", "fromString", "id", "toUUID", "Ljava/util/UUID;", "verify", "randomUUID", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] to16Bytes(BigInteger number) {
            byte[] byArray = number.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return this.to16Bytes(byArray);
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] to16Bytes(byte[] bytes) {
            byte[] byArray;
            if (bytes.length > 15) {
                byte[] byArray2 = Arrays.copyOfRange(bytes, bytes.length - 16, bytes.length);
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
            } else {
                void var2_3;
                byte[] bytes16 = new byte[16];
                System.arraycopy(bytes, 0, bytes16, 16 - bytes.length, bytes.length);
                byArray = var2_3;
            }
            return byArray;
        }

        private final BigInteger toBigInteger(String uuid) {
            Object object;
            try {
                object = uuid;
                Regex regex = new Regex("-");
                String string = "";
                object = new BigInteger(regex.replace((CharSequence)object, string), 16);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException((Serializable)((Object)uuid), "UUID");
            }
            return object;
        }

        private final String toString(BigInteger number) {
            byte[] bytes = this.to16Bytes(number);
            return this.toString(bytes);
        }

        private final String toString(byte[] bytes) {
            String string = "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x";
            Object[] objectArray = new Object[]{bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7], bytes[8], bytes[9], bytes[10], bytes[11], bytes[12], bytes[13], bytes[14], bytes[15]};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        @JvmStatic
        @NotNull
        public final TinyUUID fromString(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new TinyUUID(this.toUUID(id));
        }

        private final UUID toUUID(String id) {
            UUID uUID;
            switch (id.length()) {
                case 22: {
                    String base64 = StringsKt.replace$default((String)StringsKt.replace$default((String)id, (char)'-', (char)'+', (boolean)false, (int)4, null), (char)'_', (char)'/', (boolean)false, (int)4, null);
                    Base64.Decoder decoder = Base64.getDecoder();
                    String string = base64;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    byte[] bytes = decoder.decode(byArray);
                    Intrinsics.checkNotNull((Object)bytes);
                    uUID = this.toUUID(bytes);
                    break;
                }
                case 25: {
                    BigInteger n = new BigInteger(id, 36);
                    uUID = this.toUUID(n);
                    break;
                }
                default: {
                    UUID uUID2;
                    try {
                        uUID2 = UUID.fromString(id);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new InvalidValueException((Serializable)((Object)id), "UUID");
                    }
                    UUID uUID3 = uUID2;
                    Intrinsics.checkNotNull((Object)uUID3);
                    uUID = uUID3;
                }
            }
            return uUID;
        }

        private final UUID toUUID(BigInteger number) {
            UUID uUID = UUID.fromString(this.toString(number));
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            return uUID;
        }

        private final UUID toUUID(byte[] bytes) {
            UUID uUID = UUID.fromString(this.toString(this.verify(bytes)));
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            return uUID;
        }

        private final byte[] verify(byte[] bytes) {
            if (bytes.length != 16) {
                throw new LocalizedIllegalArgumentException(bytes, 16);
            }
            return bytes;
        }

        @JvmStatic
        @NotNull
        public final TinyUUID randomUUID() {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            return new TinyUUID(uUID);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

