/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import de.jfachwert.pruefung.exception.LocalizedValidationException;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bB#\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB/\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\r\u00a2\u0006\u0004\b\u0004\u0010\u000fB!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0004\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/jfachwert/pruefung/exception/InvalidValueException;", "Lde/jfachwert/pruefung/exception/LocalizedValidationException;", "context", "", "<init>", "(Ljava/lang/String;)V", "value", "Ljava/io/Serializable;", "(Ljava/io/Serializable;Ljava/lang/String;)V", "cause", "", "(Ljava/io/Serializable;Ljava/lang/String;Ljava/lang/Throwable;)V", "range", "Lorg/apache/commons/lang3/Range;", "", "(Ljava/io/Serializable;Ljava/lang/String;Lorg/apache/commons/lang3/Range;)V", "regex", "Lkotlin/text/Regex;", "(Ljava/io/Serializable;Ljava/lang/String;Lkotlin/text/Regex;)V", "getLocalizedMessage", "core"})
public class InvalidValueException
extends LocalizedValidationException {
    @Nullable
    private final Serializable value;
    @NotNull
    private final String context;
    @Nullable
    private final Range<? extends Comparable<?>> range;
    @Nullable
    private final Regex regex;

    public InvalidValueException(@NotNull String context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("missing value for " + StringsKt.replace$default((String)context, (char)'_', (char)' ', (boolean)false, (int)4, null));
        this.value = null;
        this.context = context;
        this.range = null;
        this.regex = null;
    }

    public InvalidValueException(@NotNull Serializable value, @NotNull String context) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("invalid value for " + StringsKt.replace$default((String)context, (char)'_', (char)' ', (boolean)false, (int)4, null) + ": \"" + value + "\"");
        this.value = value;
        this.context = context;
        this.range = null;
        this.regex = null;
    }

    public InvalidValueException(@NotNull Serializable value, @NotNull String context, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("invalid value for " + StringsKt.replace$default((String)context, (char)'_', (char)' ', (boolean)false, (int)4, null) + ": \"" + value + "\"", cause);
        this.value = value;
        this.context = context;
        this.range = null;
        this.regex = null;
    }

    public InvalidValueException(@NotNull Serializable value, @NotNull String context, @NotNull Range<? extends Comparable<?>> range) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        super("value for " + StringsKt.replace$default((String)context, (char)'_', (char)' ', (boolean)false, (int)4, null) + " is not in " + range + ": \"" + value + "\"");
        this.value = value;
        this.context = context;
        this.range = range;
        this.regex = null;
    }

    public InvalidValueException(@NotNull Serializable value, @NotNull String context, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        super("value for " + StringsKt.replace$default((String)context, (char)'_', (char)' ', (boolean)false, (int)4, null) + " does not match " + regex + ": \"" + value + "\"");
        this.value = value;
        this.context = context;
        this.range = null;
        this.regex = regex;
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        String string;
        String localizedContext = this.getLocalizedString(this.context);
        if (this.value == null) {
            Object[] objectArray = new Object[]{localizedContext};
            return this.getLocalizedMessage("pruefung.missingvalue.exception.message", objectArray);
        }
        if (this.range != null) {
            Object[] objectArray = new Object[]{this.value.toString(), localizedContext, this.range};
            string = this.getLocalizedMessage("pruefung.invalidrange.exception.message", objectArray);
        } else if (this.regex != null) {
            Object[] objectArray = new Object[]{this.value.toString(), localizedContext, this.regex};
            string = this.getLocalizedMessage("pruefung.invalidregex.exception.message", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.value.toString(), localizedContext};
            string = this.getLocalizedMessage("pruefung.invalidvalue.exception.message", objectArray);
        }
        return string;
    }
}

