/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import de.jfachwert.pruefung.exception.LocalizedValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\u0004\b\u0006\u0010\u0010J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/jfachwert/pruefung/exception/InvalidLengthException;", "Lde/jfachwert/pruefung/exception/LocalizedValidationException;", "argument", "", "expected", "", "<init>", "(Ljava/lang/String;I)V", "array", "", "([BI)V", "min", "max", "(Ljava/lang/String;II)V", "allowedLengths", "", "(Ljava/lang/String;Ljava/util/List;)V", "arguments", "", "Ljava/io/Serializable;", "[Ljava/io/Serializable;", "", "getLocalizedMessage", "Companion", "core"})
public class InvalidLengthException
extends LocalizedValidationException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializable[] arguments;
    private final int min;
    private final int max;
    @NotNull
    private final List<Integer> allowedLengths;

    public InvalidLengthException(@NotNull String argument, int expected) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        this(argument, CollectionsKt.listOf((Object)expected));
    }

    public InvalidLengthException(@NotNull byte[] array, int expected) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        super("array=" + Arrays.toString(array) + " has not length " + expected + " (but " + array.length + ")");
        this.allowedLengths = new ArrayList();
        this.min = expected;
        this.max = expected;
        this.arguments = new Serializable[array.length];
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            this.arguments[i] = Byte.valueOf(array[i]);
        }
    }

    public InvalidLengthException(@NotNull String argument, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super("'" + argument + "': length (" + argument.length() + ") is not between " + min + " and " + max);
        this.allowedLengths = new ArrayList();
        this.min = min;
        this.max = max;
        this.arguments = InvalidLengthException.Companion.asArray(argument);
    }

    public InvalidLengthException(@NotNull String argument, @NotNull List<Integer> allowedLengths) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter(allowedLengths, (String)"allowedLengths");
        super("'" + argument + "': " + argument.length() + " is not in allowed lengths " + allowedLengths);
        this.allowedLengths = new ArrayList();
        this.min = 0;
        this.max = 0;
        this.arguments = InvalidLengthException.Companion.asArray(argument);
        this.allowedLengths.addAll((Collection<Integer>)allowedLengths);
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        String string;
        String arg = String.valueOf(this.arguments[0]);
        if (this.allowedLengths.isEmpty()) {
            if (this.min < this.max) {
                Object[] objectArray = new Object[]{arg, arg.length(), this.min, this.max};
                string = this.getLocalizedMessage("pruefung.illegallength.exception.message.range", objectArray);
            } else {
                Object[] objectArray = new Object[]{Arrays.toString(this.arguments), this.arguments.length, this.min};
                string = this.getLocalizedMessage("pruefung.illegallength.exception.message.array", objectArray);
            }
        } else {
            Object[] objectArray = new Object[]{arg, arg.length(), this.allowedLengths};
            string = this.getLocalizedMessage("pruefung.illegallength.exception.message.values", objectArray);
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lde/jfachwert/pruefung/exception/InvalidLengthException$Companion;", "", "<init>", "()V", "asArray", "", "Ljava/io/Serializable;", "s", "", "(Ljava/lang/String;)[Ljava/io/Serializable;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final Serializable[] asArray(String s) {
            Serializable[] a = new Serializable[]{s};
            return a;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

