/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedArithmeticException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/jfachwert/pruefung/NumberValidator;", "Lde/jfachwert/KSimpleValidator;", "", "min", "Ljava/math/BigDecimal;", "max", "<init>", "(Ljava/math/BigDecimal;Ljava/math/BigDecimal;)V", "", "(JJ)V", "range", "Lorg/apache/commons/lang3/Range;", "validate", "value", "normalize", "verifyNumber", "", "number", "Companion", "core"})
public class NumberValidator
implements KSimpleValidator<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range<BigDecimal> range;
    @NotNull
    private static final String NUMBER = "number";
    private static final BigDecimal INFINITE = BigDecimal.valueOf(Long.MAX_VALUE);

    @JvmOverloads
    public NumberValidator(@NotNull BigDecimal min, @NotNull BigDecimal max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.range = Range.of((Comparable)min, (Comparable)max);
    }

    public /* synthetic */ NumberValidator(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bigDecimal = INFINITE.negate();
        }
        if ((n & 2) != 0) {
            bigDecimal2 = INFINITE;
        }
        this(bigDecimal, bigDecimal2);
    }

    public NumberValidator(long min, long max) {
        BigDecimal bigDecimal = BigDecimal.valueOf(min);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        BigDecimal bigDecimal2 = BigDecimal.valueOf(max);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
        this(bigDecimal, bigDecimal2);
    }

    @Override
    @NotNull
    public String validate(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String normalized = this.normalize(value);
        try {
            BigDecimal n = new BigDecimal(normalized);
            if (this.range.contains((Object)n)) {
                return normalized;
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException((Serializable)((Object)value), NUMBER, ex);
        }
        throw new InvalidValueException((Serializable)((Object)value), NUMBER, this.range);
    }

    @NotNull
    public final String normalize(@NotNull String value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        if (!new Regex("[\\d,.]+([eE]\\d+)?").matches(charSequence)) {
            throw new InvalidValueException((Serializable)((Object)value), NUMBER);
        }
        Locale locale = NumberValidator.Companion.guessLocale(value);
        NumberFormat numberFormat = DecimalFormat.getInstance(locale);
        Intrinsics.checkNotNull((Object)numberFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
        DecimalFormat df = (DecimalFormat)numberFormat;
        df.setParseBigDecimal(true);
        try {
            string = df.parse(value).toString();
        }
        catch (ParseException ex) {
            throw new InvalidValueException((Serializable)((Object)value), NUMBER, ex);
        }
        return string;
    }

    @NotNull
    public final Number verifyNumber(@NotNull Number number) {
        double dValue;
        Intrinsics.checkNotNullParameter((Object)number, (String)NUMBER);
        if ((number instanceof Double || number instanceof Float) && (Double.isNaN(dValue = number.doubleValue()) || Double.isInfinite(dValue))) {
            throw new LocalizedArithmeticException(Double.valueOf(dValue), NUMBER);
        }
        return number;
    }

    @Override
    @Nullable
    public Object validateObject(@NotNull Object value) {
        return KSimpleValidator.DefaultImpls.validateObject(this, value);
    }

    @Override
    @NotNull
    public String verify(@NotNull String value) {
        return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
    }

    @JvmOverloads
    public NumberValidator(@NotNull BigDecimal min) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        this(min, null, 2, null);
    }

    @JvmOverloads
    public NumberValidator() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/pruefung/NumberValidator$Companion;", "", "<init>", "()V", "NUMBER", "", "INFINITE", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "getINFINITE", "()Ljava/math/BigDecimal;", "Ljava/math/BigDecimal;", "guessLocale", "Ljava/util/Locale;", "value", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final BigDecimal getINFINITE() {
            return INFINITE;
        }

        private final Locale guessLocale(String value) {
            Locale locale;
            CharSequence charSequence = value;
            if (new Regex("\\d+(\\.\\d{3})*(,\\d+)?").matches(charSequence)) {
                Locale locale2 = Locale.GERMAN;
                locale = locale2;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"GERMAN");
            } else {
                Locale locale3 = Locale.ENGLISH;
                locale = locale3;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"ENGLISH");
            }
            return locale;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

