package de.jensklingenberg.ktorfit

import de.jensklingenberg.ktorfit.adapter.KtorfitCallResponseConverter
import de.jensklingenberg.ktorfit.adapter.ResponseConverter
import io.ktor.client.*


/**
 * Main class for Ktorfit, create the class than use the [create<T>()] function.
 * @param baseUrl that will be used for every request with object
 * @param httpClient client that will be used for every request with object
 */
class Ktorfit(var baseUrl: String, var httpClient: HttpClient = HttpClient()) {

    private val responseConverters: MutableList<ResponseConverter> = mutableListOf()


    init {
        if (baseUrl.isEmpty()) {
            throw IllegalStateException("Base URL required")
        }

        if (!baseUrl.endsWith("/")) {
            throw IllegalStateException("Base URL needs to end with /")
        }
        addResponseConverter(KtorfitCallResponseConverter())
    }

    /**
     * Use this to add [ResponseConverter] for unsupported return types of requests
     */
    fun addResponseConverter(ResponseConverter: ResponseConverter): Ktorfit {
        responseConverters.add(ResponseConverter)
        return this
    }

    fun getResponseConverters() = responseConverters

}

/**
 * This will make IntelliJ think that this function exists.
 * The real implementation will be generated by the KSP plugin
 * Ktorfit will return an implementation of type [T] for a requested interface
 *
 * val ktorfit = Ktorfit("example.com")
 * val testApi = ktorfit.create<TestApi>()
 */

inline fun <reified T> Ktorfit.create(): T {
    throw NotImplementedError("Ktorfit didn't generate Code for " + T::class.simpleName + " You need to apply the KSP Plugin")
}
