package de.jensklingenberg.ktorfit.adapter

import io.ktor.client.statement.*

interface CallAdapter  {

    enum class SupportType {
        /**
         * This adapter transforms response of [supportedType] into an other type
         */
        CONVERTRESPONSE,

        /**
         * This adapter transforms a suspend function into a non suspend function
         */
        CONVERTSUSPENDCALL
    }
    fun <T> convertResponse(httpResponse: Any): T
    fun getSupported(): List<SupportType>

    fun supportedType(returnTypeName: String): Boolean
    fun <PRequest : Any> convertSuspendCall(
        returnTypeName: String,
        function: suspend () -> Pair<PRequest, HttpResponse>
    ): Any

}
