package de.jensklingenberg.ktorfit

import de.jensklingenberg.ktorfit.adapter.CallAdapter
import de.jensklingenberg.ktorfit.adapter.KtorfitCallAdapter
import io.ktor.client.*


/**
 * Main class for Ktorfit, create the class than use the [create<T>()] function.
 * @param baseUrl that will be used for every request with object
 * @param httpClient client that will be used for every request with object
 */
class Ktorfit(val baseUrl: String, var httpClient: HttpClient = HttpClient()) {

    private val adapterList: MutableList<CallAdapter> = mutableListOf()

    init {
        if (baseUrl.isEmpty()) {
            throw IllegalStateException("Base URL required")
        }

        if (!baseUrl.endsWith("/")) {
            throw IllegalStateException("Base URL needs to end with /")
        }
        addAdapter(KtorfitCallAdapter())
    }

    /**
     * Use this to add [CallAdapter] for unsupported return types of requests
     */
    fun addAdapter(callAdapter: CallAdapter): Ktorfit {
        adapterList.add(callAdapter)
        return this
    }

    fun getAdapterList() = adapterList

}

/**
 * This will make IntelliJ think that this function exists.
 * The real implementation will be generated by the KSP plugin
 * Ktorfit will return a implementation of type [T] for a requested interface
 *
 * val ktorfit = Ktorfit("example.com")
 * val testApi = ktorfit.create<TestApi>()
 */
inline fun <reified T> Ktorfit.create(): T {
    throw NotImplementedError("Ktorfit didn't generate Code for " + T::class.simpleName + " You need to apply the KSP Plugin")
}
