package de.jensklingenberg.ktorfit.internal

/**
 * This will be implemented by classes that
 * are generated by Ktorfit-Ksp.
 */
public interface KtorfitService {
    public var ktorfitClient: Client

    /**
     * Used to set the [ktorfitClient] at runtime
     */
    public fun setClient(ktorfitClient: Client) {
        this.ktorfitClient = ktorfitClient
    }
}

/**
 * This will be used as default parameter for [Ktorfit.create].
 * When this class is used at runtime, it means that the compiler plugin
 * did not replace the default parameter with the right class
 */
@OptIn(InternalKtorfitApi::class)
internal class DefaultKtorfitService : KtorfitService {
    override lateinit var ktorfitClient: Client
}