package de.jensklingenberg.ktorfit.adapter

import de.jensklingenberg.ktorfit.Call
import de.jensklingenberg.ktorfit.Callback
import io.ktor.client.statement.*
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.async
import kotlinx.coroutines.launch

class KtorfitCallAdapter : CallAdapter {

    override fun getSupported(): List<CallAdapter.SupportType> {
        return listOf(CallAdapter.SupportType.CONVERTSUSPENDCALL)
    }

    override fun supportedType(returnTypeName: String): Boolean {
        return returnTypeName == "de.jensklingenberg.ktorfit.Call"
    }

    override fun <T : Any> convertSuspendCall(
        returnTypeName: String,
        function: suspend () -> Pair<T, HttpResponse>
    ): Call<T> {
        return object : Call<T> {
            override fun onExecute(callBack: Callback<T>) {
                GlobalScope.launch {
                    val deferredResponse = async { function() }

                    val (data, response) = deferredResponse.await()
                    callBack.onResponse(data, response)
                }
            }

        }
    }

    override fun <T> convertResponse(httpResponse: Any): T {
        TODO("Not yet implemented")
    }

}