package de.jensklingenberg.ktorfit.adapter

import io.ktor.client.statement.*
import kotlinx.coroutines.flow.flow

class FlowCallAdapter : CallAdapter {
    override fun getSupported(): List<CallAdapter.SupportType> {
        return listOf(CallAdapter.SupportType.CONVERTSUSPENDCALL)
    }

    override fun supportedType(returnTypeName: String): Boolean {
        return returnTypeName == "kotlinx.coroutines.flow.Flow"
    }

    override fun <PRequest : Any> convertSuspendCall(
        returnTypeName: String,
        function: suspend () -> Pair<PRequest, HttpResponse>
    ): Any {
        return flow {
            emit(function().first)
        }
    }

    override fun <T> convertResponse(httpResponse: Any): T {
        TODO("Not yet implemented")
    }


}


