package de.jensklingenberg.ktorfit

import io.ktor.client.request.*

/**
 * @param method HTTP Keyword of requested Http Method Type
 * @param relativeUrl This is the request relative url path e.g. "posts/1"
 * @param headers map of Headers that will be used for request
 * @param queries map of query parameters that will be added to the requested url
 * @param fields map of fields parameters that will be added to the formData Body
 * @param bodyData data that will send to with the request
 * @param qualifiedRawTypeName This is the qualifiedName of [TReturn]
 * It will be used by [CallAdapter] to check if they support the type
 * Because on JS the qualifiedName reflection does not exist, it is inserted as arguments by the Compiler Plugin
 */
data class RequestData(
    val method: String,
    val relativeUrl: String,
    val headers: Map<String, Any> = emptyMap(),
    val queries: Map<String, Any> = emptyMap(),
    val fields: Map<String, String> = emptyMap(),
    val parts: Map<String, Any> = emptyMap(),
    val bodyData: Any? = null,
    val qualifiedRawTypeName: String,
    val requestBuilder: HttpRequestBuilder.() -> Unit = {}
)