/*
 * Decompiled with CFR 0.152.
 */
package de.jensklingenberg.ktorfit.parser;

import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import de.jensklingenberg.ktorfit.UtilsKt;
import de.jensklingenberg.ktorfit.model.ParameterData;
import de.jensklingenberg.ktorfit.model.TypeData;
import de.jensklingenberg.ktorfit.model.annotations.Body;
import de.jensklingenberg.ktorfit.model.annotations.Field;
import de.jensklingenberg.ktorfit.model.annotations.FieldMap;
import de.jensklingenberg.ktorfit.model.annotations.Header;
import de.jensklingenberg.ktorfit.model.annotations.HeaderMap;
import de.jensklingenberg.ktorfit.model.annotations.ParameterAnnotation;
import de.jensklingenberg.ktorfit.model.annotations.Part;
import de.jensklingenberg.ktorfit.model.annotations.PartMap;
import de.jensklingenberg.ktorfit.model.annotations.Path;
import de.jensklingenberg.ktorfit.model.annotations.Query;
import de.jensklingenberg.ktorfit.model.annotations.QueryMap;
import de.jensklingenberg.ktorfit.model.annotations.QueryName;
import de.jensklingenberg.ktorfit.model.annotations.RequestBuilder;
import de.jensklingenberg.ktorfit.model.annotations.Url;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"getParamAnnotationList", "", "Lde/jensklingenberg/ktorfit/model/annotations/ParameterAnnotation;", "ksValueParameter", "Lcom/google/devtools/ksp/symbol/KSValueParameter;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "getParameterData", "Lde/jensklingenberg/ktorfit/model/ParameterData;", "ktorfit-ksp"})
public final class ParameterParserKt {
    @NotNull
    public static final ParameterData getParameterData(@NotNull KSValueParameter ksValueParameter, @NotNull KSPLogger logger) {
        TypeData typeData;
        boolean hasRequestBuilderAnno;
        Intrinsics.checkNotNullParameter((Object)ksValueParameter, (String)"ksValueParameter");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (ksValueParameter.isVararg()) {
            UtilsKt.ktorfitError(logger, "vararg not supported use List or Array", (KSNode)ksValueParameter);
        }
        if (ksValueParameter.getType().resolve().isMarkedNullable()) {
            UtilsKt.ktorfitError(logger, "Nullable Parameters are not supported", (KSNode)ksValueParameter);
        }
        List<ParameterAnnotation> pararameterAnnotations = ParameterParserKt.getParamAnnotationList(ksValueParameter, logger);
        RequestBuilder reqBuilderAnno = UtilsKt.getRequestBuilderAnnotation(ksValueParameter);
        Object object = ksValueParameter.getName();
        if (object == null || (object = object.asString()) == null) {
            object = "";
        }
        Object parameterName = object;
        KSType parameterType = ksValueParameter.getType().resolve();
        boolean bl = hasRequestBuilderAnno = reqBuilderAnno != null;
        if (pararameterAnnotations.isEmpty() && reqBuilderAnno == null) {
            UtilsKt.ktorfitError(logger, "No Ktorfit Annotation found at " + (String)parameterName + ' ' + ksValueParameter.getParent(), (KSNode)ksValueParameter);
        }
        if (hasRequestBuilderAnno && !Intrinsics.areEqual((Object)UtilsKt.resolveTypeName(parameterType), (Object)"[@kotlin.ExtensionFunctionType] Function1<HttpRequestBuilder, Unit>")) {
            UtilsKt.ktorfitError(logger, "@ReqBuilder parameter type needs to be HttpRequestBuilder.()->Unit", (KSNode)ksValueParameter);
        }
        if (hasRequestBuilderAnno) {
            typeData = new TypeData("HttpRequestBuilder.()->Unit", "HttpRequestBuilder.()->Unit");
        } else {
            String string = UtilsKt.resolveTypeName(parameterType);
            Object object2 = parameterType.getDeclaration().getQualifiedName();
            if (object2 == null || (object2 = object2.asString()) == null) {
                object2 = "";
            }
            typeData = new TypeData(string, (String)object2);
        }
        TypeData type = typeData;
        return new ParameterData((String)parameterName, type, pararameterAnnotations, hasRequestBuilderAnno);
    }

    @NotNull
    public static final List<ParameterAnnotation> getParamAnnotationList(@NotNull KSValueParameter ksValueParameter, @NotNull KSPLogger logger) {
        List pararamAnnos;
        block36: {
            ParameterAnnotation it;
            block33: {
                block35: {
                    block34: {
                        KSTypeArgument mapKey;
                        block30: {
                            block32: {
                                block31: {
                                    block27: {
                                        block29: {
                                            block28: {
                                                Intrinsics.checkNotNullParameter((Object)ksValueParameter, (String)"ksValueParameter");
                                                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                                                pararamAnnos = new ArrayList();
                                                Body body = UtilsKt.getBodyAnnotation(ksValueParameter);
                                                if (body != null) {
                                                    it = body;
                                                    boolean bl = false;
                                                    pararamAnnos.add(it);
                                                }
                                                Path path = UtilsKt.getPathAnnotation(ksValueParameter);
                                                if (path != null) {
                                                    it = path;
                                                    boolean bl = false;
                                                    if (ksValueParameter.getType().resolve().isMarkedNullable()) {
                                                        UtilsKt.ktorfitError(logger, "Path parameter type may not be nullable", (KSNode)ksValueParameter.getType());
                                                    }
                                                    pararamAnnos.add(it);
                                                }
                                                Header header = UtilsKt.getHeadersAnnotation(ksValueParameter);
                                                if (header != null) {
                                                    it = header;
                                                    boolean bl = false;
                                                    pararamAnnos.add(it);
                                                }
                                                HeaderMap headerMap = UtilsKt.getHeaderMapAnnotation(ksValueParameter);
                                                if (headerMap == null) break block27;
                                                it = headerMap;
                                                boolean bl = false;
                                                if (!StringsKt.endsWith$default((String)ksValueParameter.getType().toString(), (String)"Map", (boolean)false, (int)2, null)) {
                                                    UtilsKt.ktorfitError(logger, "@HeaderMap parameter type must be Map.", (KSNode)ksValueParameter);
                                                }
                                                if (!Intrinsics.areEqual((Object)String.valueOf((mapKey = (KSTypeArgument)CollectionsKt.first((List)ksValueParameter.getType().resolve().getArguments())).getType()), (Object)"String")) break block28;
                                                KSTypeReference kSTypeReference = mapKey.getType();
                                                boolean bl2 = kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.isMarkedNullable() : false;
                                                if (!bl2) break block29;
                                            }
                                            logger.error("@HeaderMap keys must be of type String:", (KSNode)ksValueParameter);
                                        }
                                        pararamAnnos.add(it);
                                    }
                                    Query query = UtilsKt.getQueryAnnotation(ksValueParameter);
                                    if (query != null) {
                                        it = query;
                                        boolean bl = false;
                                        pararamAnnos.add(it);
                                    }
                                    QueryName queryName = UtilsKt.getQueryNameAnnotation(ksValueParameter);
                                    if (queryName != null) {
                                        it = queryName;
                                        boolean bl = false;
                                        pararamAnnos.add(it);
                                    }
                                    QueryMap queryMap = UtilsKt.getQueryMapAnnotation(ksValueParameter);
                                    if (queryMap == null) break block30;
                                    it = queryMap;
                                    boolean bl = false;
                                    if (!StringsKt.endsWith$default((String)ksValueParameter.getType().toString(), (String)"Map", (boolean)false, (int)2, null)) {
                                        logger.error("@QueryMap parameter type must be Map.", (KSNode)ksValueParameter);
                                    }
                                    if (!Intrinsics.areEqual((Object)String.valueOf((mapKey = (KSTypeArgument)CollectionsKt.first((List)ksValueParameter.getType().resolve().getArguments())).getType()), (Object)"String")) break block31;
                                    KSTypeReference kSTypeReference = mapKey.getType();
                                    boolean bl3 = kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.isMarkedNullable() : false;
                                    if (!bl3) break block32;
                                }
                                logger.error("@QueryMap keys must be of type String:", (KSNode)ksValueParameter);
                            }
                            if (ksValueParameter.getType().resolve().isMarkedNullable()) {
                                UtilsKt.ktorfitError(logger, "QueryMap parameter type may not be nullable", (KSNode)ksValueParameter.getType());
                            }
                            pararamAnnos.add(it);
                        }
                        Field field = UtilsKt.getFieldAnnotation(ksValueParameter);
                        if (field != null) {
                            it = field;
                            boolean bl = false;
                            pararamAnnos.add(it);
                        }
                        FieldMap fieldMap = UtilsKt.getFieldMapAnnotation(ksValueParameter);
                        if (fieldMap == null) break block33;
                        it = fieldMap;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)ksValueParameter.getType().toString(), (String)"Map", (boolean)false, (int)2, null)) {
                            UtilsKt.ktorfitError(logger, "@FieldMap parameter type must be Map.", (KSNode)ksValueParameter);
                        }
                        if (!Intrinsics.areEqual((Object)String.valueOf((mapKey = (KSTypeArgument)CollectionsKt.first((List)ksValueParameter.getType().resolve().getArguments())).getType()), (Object)"String")) break block34;
                        KSTypeReference kSTypeReference = mapKey.getType();
                        boolean bl4 = kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.isMarkedNullable() : false;
                        if (!bl4) break block35;
                    }
                    logger.error("@FieldMap keys must be of type String:", (KSNode)ksValueParameter);
                }
                pararamAnnos.add(it);
            }
            Part part = UtilsKt.getPartAnnotation(ksValueParameter);
            if (part != null) {
                it = part;
                boolean bl = false;
                if (ksValueParameter.getType().resolve().isMarkedNullable()) {
                    UtilsKt.ktorfitError(logger, "Part parameter type may not be nullable", (KSNode)ksValueParameter.getType());
                }
                pararamAnnos.add(it);
            }
            PartMap partMap = UtilsKt.getPartMapAnnotation(ksValueParameter);
            if (partMap != null) {
                it = partMap;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)ksValueParameter.getType().toString(), (String)"Map", (boolean)false, (int)2, null)) {
                    UtilsKt.ktorfitError(logger, "@PartMap parameter type must be Map.", (KSNode)ksValueParameter);
                }
                pararamAnnos.add(it);
            }
            Url url = UtilsKt.getUrlAnnotation(ksValueParameter);
            if (url == null) break block36;
            it = url;
            boolean bl = false;
            pararamAnnos.add(it);
        }
        return pararamAnnos;
    }
}

