package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.model.MyClass
import de.jensklingenberg.ktorfit.resolveTypeName

class ClassNode(private val myClass: MyClass, private val funcNodes: List<FuncNode> = emptyList()) : MyNode() {

    override fun toString(): String {

        val supertypes = generateSuperTypesText(myClass)
        val packageText = "package ${myClass.packageName}"
        val superclassName = myClass.name
        val funcText = funcNodes.joinToString(separator = "")
        val superClassImport = "import ${myClass.packageName}.$superclassName"
        val imports = myClass.imports.joinToString("\n") { it } + "\n" +superClassImport

        val implClassName = """_${superclassName}Impl"""

        val propsText = getPropertiesText()

        return """//Generated by Ktorfit
$packageText
$imports

class $implClassName(val client : KtorfitClient) : $superclassName $supertypes {
$funcText
$propsText
}"""
    }

    private fun getPropertiesText() = myClass.properties.joinToString("\n") { property ->
        val propertyName = property.simpleName.asString()
        val typeName = property.type.resolve().resolveTypeName()
        val mutableText = if (property.isMutable) {
            "var"
        } else {
            "val"
        }

        val propText = if (property.isMutable) {
            "\n set(value) {}"
        } else {
            ""
        }

        "override $mutableText $propertyName : $typeName \n get() {\n TODO(\"Not yet implemented\")\n } $propText"
    }

    /**
     * Support for extending multiple interfaces, is done with Kotlin delegation. Ktorfit interfaces can only extend other Ktorfit interfaces, so there will
     * be a generated implementation for each interface that we can use.
     */
    private fun generateSuperTypesText(myClass: MyClass): String {
        return myClass.superClasses.joinToString("") { superClassQualifiedName ->
            val superTypeClassName = superClassQualifiedName.substringAfterLast(".")
            val superTypePackage = superClassQualifiedName.substringBeforeLast(".")

            ", $superClassQualifiedName by ${superTypePackage}._${superTypeClassName}Impl(client)"
        }
    }

}