package de.jensklingenberg.ktorfit.generator

import de.jensklingenberg.ktorfit.model.MyClass

/**
 * This will generate the Ktorfit.create() extension function
 */
fun generateHttpExtSource(
    myClasses: List<MyClass>,
    isJS: Boolean = false
): String {
    val classNameReflectionMethod = if (isJS) {
        /**
         * On JS "simpleName" is used to get class name, because qualifiedName does not exists
         */
        //https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/qualified-name.html
        "simpleName"
    } else {
        "qualifiedName"
    }


    val whenBody = myClasses.joinToString(separator = "\n") {
        val className = it.name
        " T::class ==  ${it.packageName}.${className}::class ->{\n" +
                "          ${it.packageName}._${className}Impl(KtorfitClient(this)) as T\n" +
                "}"
    }

    return """
//Generated by Ktorfit 
package de.jensklingenberg.ktorfit
import de.jensklingenberg.ktorfit.internal.KtorfitClient
inline fun <reified T> Ktorfit.create(): T{
return when{
$whenBody
else -> {
throw IllegalArgumentException("Could not find any Ktorfit annotations in class "+ T::class.$classNameReflectionMethod  )
}}}""".trimIndent()
}