package de.jensklingenberg.ktorfit.parser

import com.google.devtools.ksp.getDeclaredFunctions
import com.google.devtools.ksp.processing.KSPLogger
import com.google.devtools.ksp.symbol.KSClassDeclaration
import de.jensklingenberg.ktorfit.model.MyClass
import de.jensklingenberg.ktorfit.model.MyFunction
import java.io.File


/**
 *  //TODO: Find better way to get imports
 */
private fun getImports(ksClassDeclaration: KSClassDeclaration): List<String> {
    val importList =
        File(ksClassDeclaration.containingFile!!.filePath)
            .readLines()
            .filter { it.trimStart().startsWith("import") }
            .toMutableList()

    importList.addIfAbsent("import de.jensklingenberg.ktorfit.Ktorfit")

    importList.addIfAbsent("import de.jensklingenberg.ktorfit.KtorfitClient")

    importList.addIfAbsent("import de.jensklingenberg.ktorfit.RequestData")

    return importList
}

private fun  MutableList<String>.addIfAbsent(e2: String) {
    if (this.none { it.contains(e2) }) {
        this.add(e2)
    }
}

fun readClass(ksClassDeclaration: KSClassDeclaration, logger: KSPLogger): MyClass {

    val myFunctions: List<MyFunction> = getMyFunctionsList(ksClassDeclaration.getDeclaredFunctions().toList(), logger)

    val imports = getImports(ksClassDeclaration)
    val packageName = ksClassDeclaration.packageName.asString()
    val className = ksClassDeclaration.simpleName.asString()

    val supertypes =
        ksClassDeclaration.superTypes.toList().mapNotNull { it.resolve().declaration.qualifiedName?.asString() }
    return MyClass(className, packageName, myFunctions, imports, supertypes)
}
