package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.findAnnotationOrNull
import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.hasAnnotation
import de.jensklingenberg.ktorfit.model.MyFunction
import de.jensklingenberg.ktorfit.model.annotations.Path
import de.jensklingenberg.ktorfit.model.annotations.QueryName
import de.jensklingenberg.ktorfit.model.annotations.Url
import de.jensklingenberg.ktorfit.prefixIfNotEmpty

/**
 * Source for the "relativeUrl" argument of [de.jensklingenberg.ktorfit.RequestData]
 */
class RelativeUrlArgumentNode(private val myFunction: MyFunction) : MyNode() {

    override fun toString(): String {
        val methodAnnotation = myFunction.httpMethodAnnotation

        var urlPath = if (methodAnnotation.path.isNotEmpty()) {
            //url="posts"
            methodAnnotation.path
        } else {
            myFunction.params.firstOrNull { it.hasAnnotation<Url>() }?.let {
                //url=$foo
                "\${" + it.name + "}"
            } ?: ""
        }
        /**
         * Replace all values with curly braces in url path to corresponding annotated parameter names
         */
        myFunction.params.filter { it.hasAnnotation<Path>() }.forEach { myParam ->
            val paramName = myParam.name
            val pathAnnotation = myParam.findAnnotationOrNull<Path>()
            val pathPath = pathAnnotation?.value ?: ""
            val pathEncoded = pathAnnotation?.encoded ?: false

            val newPathValue = if (!pathEncoded) {
                "\${client.encode($paramName)}"
            } else {
                "\${$paramName}"
            }

            urlPath = urlPath.replace("{${pathPath}}", newPathValue)
        }

        /**
         * QueryName values will be appended to the url, because i don't know how to set this with Ktor
         */
        val queryText = myFunction.params.filter { it.hasAnnotation<QueryName>() }.joinToString { myParam ->
            val paramName = myParam.name
            val query = (myParam.annotations.firstOrNull { it is QueryName } as QueryName)
            var queryKeyName = "\${$paramName}"

            if (!query.encoded) {
                queryKeyName = "client.encode($queryKeyName)"
            }
            queryKeyName
        }.prefixIfNotEmpty("?")

        return "relativeUrl=\"$urlPath$queryText\""
    }
}