package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.findAnnotationOrNull
import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.hasAnnotation
import de.jensklingenberg.ktorfit.model.MyParam
import de.jensklingenberg.ktorfit.model.annotations.Query
import de.jensklingenberg.ktorfit.model.annotations.QueryMap
import de.jensklingenberg.ktorfit.prefixIfNotEmpty
import de.jensklingenberg.ktorfit.surroundIfNotEmpty
import java.net.URLEncoder

/**
 * Source for the "queries" argument of [de.jensklingenberg.ktorfit.RequestData]
 */
class QueryArgumentNode(private val params: List<MyParam>) : MyNode() {

    override fun toString(): String {
        //Get all Parameter with @Query and add them to a map
        var queryText = params.filter { it.hasAnnotation<Query>() }.map { myParam ->
            val paramName = myParam.name
            val query = myParam.annotations.filterIsInstance<Query>().first()
            var queryKeyName = query.value
            var queryValueName = "\"\${$paramName}\""

            if (!query.encoded) {
                queryKeyName = URLEncoder.encode(queryKeyName)
                queryValueName = "client.encode($queryValueName)"
            }

            "\"$queryKeyName\" to $queryValueName"
        }.joinToString { it }.surroundIfNotEmpty("mapOf(", ")")

        params.filter { it.hasAnnotation<QueryMap>() }.forEach { myParam ->
            val queryMap = myParam.findAnnotationOrNull<QueryMap>()!!
            var mapName = myParam.name

            if (!queryMap.encoded) {
                mapName = "client.encodeMap($mapName)"
            }

            queryText += ("+".takeIf { queryText.isNotEmpty() } ?: "") + mapName
        }
        return queryText.prefixIfNotEmpty("queries = ")
    }
}