package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.hasAnnotation
import de.jensklingenberg.ktorfit.model.MyParam
import de.jensklingenberg.ktorfit.model.annotations.Part
import de.jensklingenberg.ktorfit.model.annotations.PartMap
import de.jensklingenberg.ktorfit.prefixIfNotEmpty
import de.jensklingenberg.ktorfit.surroundIfNotEmpty

/**
 * Source for the "parts" argument of [de.jensklingenberg.ktorfit.RequestData]
 */
class PartsArgumentNode(private val params: List<MyParam>) : MyNode() {

    override fun toString(): String {
        val paramsWithPartMapAnno = params.filter { it.hasAnnotation<PartMap>() }
        val paramsWithPartAnno = params.filter { it.hasAnnotation<Part>() }

        var partsText = paramsWithPartAnno.joinToString { myParam ->
            val paramName = myParam.name
            val part = myParam.annotations.filterIsInstance<Part>().first()
            val partKeyName = part.value

            "\"$partKeyName\" to $paramName"
        }.surroundIfNotEmpty("mapOf(", ")")


        partsText += paramsWithPartMapAnno.joinToString("") { myParam ->
            ("+".takeIf { partsText.isNotEmpty() } ?: "") + myParam.name
        }
        return partsText.prefixIfNotEmpty("parts = ")
    }
}