package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.findAnnotationOrNull
import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.hasAnnotation
import de.jensklingenberg.ktorfit.model.MyParam
import de.jensklingenberg.ktorfit.model.annotations.FormUrlEncoded
import de.jensklingenberg.ktorfit.model.annotations.FunctionAnnotation
import de.jensklingenberg.ktorfit.model.annotations.Header
import de.jensklingenberg.ktorfit.model.annotations.HeaderMap
import de.jensklingenberg.ktorfit.model.annotations.Headers
import de.jensklingenberg.ktorfit.prefixIfNotEmpty
import de.jensklingenberg.ktorfit.surroundIfNotEmpty


/**
 * Source for the "headers" argument of [de.jensklingenberg.ktorfit.RequestData]
 */
class HeadersArgumentNode(
    private val functionAnnotations: List<FunctionAnnotation>,
    private val paramList: List<MyParam>
) : MyNode() {

    override fun toString(): String {
        val headerMap = mutableMapOf<String, String>()

        val paramsWithHeaderAnno = paramList.filter { it.hasAnnotation<Header>() }
        val headersAnno = functionAnnotations.filterIsInstance<Headers>().firstOrNull()
        val paramsWithHeaderMap = paramList.filter { it.hasAnnotation<HeaderMap>() }

        if (functionAnnotations.any { it is FormUrlEncoded }) {
            headerMap["Content-Type"] = "\"application/x-www-form-urlencoded\""
        }

        paramsWithHeaderAnno.forEach { myParam ->
            val paramName = myParam.name
            val queryPath = myParam.findAnnotationOrNull<Header>()?.path ?: ""

            headerMap[queryPath] = "\"\${$paramName}\""
        }

        headersAnno?.let { headers ->
            headers.path.forEach {
                val (key, value) = it.split(":")
                headerMap[key] = "\"$value\""
            }
        }

        var queryText = headerMap.map {
            "\"${it.key}\" to ${it.value}"
        }.joinToString { it }.surroundIfNotEmpty("mapOf(", ")")


        queryText += paramsWithHeaderMap.joinToString("") {
            ("+".takeIf { queryText.isNotEmpty() } ?: "") + it.name
        }
        return queryText.prefixIfNotEmpty("headers = ")
    }
}