package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.generator.ParamCmd
import de.jensklingenberg.ktorfit.model.MyFunction

class FuncNode(private val myFunction: MyFunction, private val bodyCmd: FuncBodyNode, private val paramCmd: List<ParamCmd>) :
    MyNode() {

    override fun toString(): String {
        val returnTypeName = myFunction.returnType.name
        val paramsText = paramCmd.joinToString { it.toString() }
        val suspendModifierText = "suspend".takeIf { myFunction.isSuspend } ?: ""

        return """override $suspendModifierText fun ${myFunction.name}($paramsText): $returnTypeName {
                        $bodyCmd
                    }
                    """
    }
}