package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.findAnnotationOrNull
import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.hasAnnotation
import de.jensklingenberg.ktorfit.model.MyParam
import de.jensklingenberg.ktorfit.model.annotations.Field
import de.jensklingenberg.ktorfit.model.annotations.FieldMap
import de.jensklingenberg.ktorfit.prefixIfNotEmpty
import de.jensklingenberg.ktorfit.surroundIfNotEmpty
import java.net.URLEncoder

/**
 * Source for the "fields" argument of [de.jensklingenberg.ktorfit.RequestData]
 */
class FieldArgumentsNode(private val params: List<MyParam>) : MyNode() {

    override fun toString(): String {
        val paramsWithFieldAnnotation = params.filter { it.hasAnnotation<Field>() }
        val paramsWithFieldMapAnnotation = params.filter { it.hasAnnotation<FieldMap>() }

        var fieldsText = paramsWithFieldAnnotation.joinToString { myParam ->
            val paramName = myParam.name
            val field = myParam.annotations.filterIsInstance<Field>().first()
            var fieldKeyName = field.value
            var fieldValueName = "\"\${$paramName}\""

            if (!field.encoded) {
                fieldKeyName = URLEncoder.encode(fieldKeyName)
                fieldValueName = "client.encode($fieldValueName)"
            }

            "\"$fieldKeyName\" to $fieldValueName"
        }.surroundIfNotEmpty("mapOf(", ")")


        fieldsText += paramsWithFieldMapAnnotation.joinToString { myParam ->
            val queryMap = myParam.findAnnotationOrNull<FieldMap>()!!
            var mapName = myParam.name
            if (!queryMap.encoded) {
                mapName = "client.encodeMap($mapName)"
            }

            ("+".takeIf { fieldsText.isNotEmpty() } ?: "") + mapName
        }
        return fieldsText.prefixIfNotEmpty("fields = ")
    }
}