package de.jensklingenberg.ktorfit.node

import de.jensklingenberg.ktorfit.generator.MyNode
import de.jensklingenberg.ktorfit.model.MyClass

class ClassNode(private val myClass: MyClass, private val commands: List<FuncNode> = emptyList()) : MyNode() {

    override fun toString(): String {

        val supertypes = generateSuperTypesText(myClass)
        val packageText = "package ${myClass.packageName}"
        val className = myClass.name
        val funcText = commands.joinToString(separator = "")
        val imports = myClass.imports.joinToString("\n") { it }

        return """//Generated by Ktorfit
                    $packageText
                    import ${myClass.packageName}.$className
                    $imports
                    
                    class _${className}Impl(val client : KtorfitClient) : $className $supertypes {
                    $funcText
                    }"""
    }

    /**
     * Support for extending interfaces, is done with Kotlin delegation. Ktorfit interfaces can only extend other Ktorfit interfaces, so there will
     * be a generated implementation for each interface that we can use.
     */
    private fun generateSuperTypesText(myClass: MyClass): String {
        return myClass.superClasses.joinToString("") { superClassQualifiedName ->
            val superTypeClassName = superClassQualifiedName.substringAfterLast(".")
            val superTypePackage = superClassQualifiedName.substringBeforeLast(".")
            ", $superClassQualifiedName by ${superTypePackage}._${superTypeClassName}Impl(client)"
        }
    }

}