package de.jensklingenberg.ktorfit.generator

import de.jensklingenberg.ktorfit.model.MyClass

/**
 * This will generate the Ktorfit.create() extension function
 */
fun generateHttpExtSource(
    myClasses: List<MyClass>,
    isJS: Boolean = false
): String {
    val classNameReflectionMethod = if (isJS) {
        /**
         * On JS "simpleName" is used to get class name, because qualifiedName does not exists
         */
        //https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/qualified-name.html
        "simpleName"
    } else {
        "qualifiedName"
    }
    val serviceClassImport = myClasses.joinToString(separator = "\n") {
        val packageName = it.packageName
        val className = it.name
        "import $packageName._${className}Impl\nimport $packageName.${className}"
    }

    val whenBody = myClasses.joinToString(separator = "\n") {
        val className = it.name
        "${className}::class.$classNameReflectionMethod->{\n" +
                "          _${className}Impl(KtorfitClient(this)) as T\n" +
                "}"
    }

    return """
//Generated by Ktorfit 
package de.jensklingenberg.ktorfit
$serviceClassImport
inline fun <reified T> Ktorfit.create(): T{
return when(T::class.$classNameReflectionMethod){
$whenBody
else -> {
throw IllegalArgumentException("Could not find any Ktorfit annotations in class "+ T::class.$classNameReflectionMethod  )
}}}""".trimIndent()
}