package de.jensklingenberg.ktorfit

import com.google.auto.service.AutoService
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption
import org.jetbrains.kotlin.compiler.plugin.CliOption
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor
import org.jetbrains.kotlin.compiler.plugin.ExperimentalCompilerApi
import org.jetbrains.kotlin.config.CompilerConfiguration
import org.jetbrains.kotlin.config.CompilerConfigurationKey

@OptIn(ExperimentalCompilerApi::class)
@AutoService(CommandLineProcessor::class) // don't forget!
class ExampleCommandLineProcessor : CommandLineProcessor {
    override val pluginId: String = "ktorfitPlugin"

    override val pluginOptions: Collection<CliOption> =
        listOf(
            CliOption(
                optionName = "enabled",
                valueDescription = "<true|false>",
                description = "whether to enable the plugin or not",
            ),
            CliOption(
                optionName = "logging",
                valueDescription = "<true|false>",
                description = "whether to enable logging",
            ),
        )

    override fun processOption(
        option: AbstractCliOption,
        value: String,
        configuration: CompilerConfiguration,
    ) = when (option.optionName) {
        "enabled" -> configuration.put(KEY_ENABLED, value.toBoolean())
        "logging" -> configuration.put(KEY_LOGGING, value.toBoolean())
        else -> configuration.put(KEY_ENABLED, true)
    }
}

val KEY_ENABLED = CompilerConfigurationKey<Boolean>("whether the plugin is enabled")
val KEY_LOGGING = CompilerConfigurationKey<Boolean>("whether logging is enabled")
