/*
 * Decompiled with CFR 0.152.
 */
package de.jensklingenberg.ktorfit;

import com.google.auto.service.AutoService;
import de.jensklingenberg.ktorfit.ExampleCommandLineProcessorKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lde/jensklingenberg/ktorfit/ExampleCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptions", "()Ljava/util/Collection;", "processOption", "", "option", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "ktorfit-compiler-plugin"})
@AutoService(value={CommandLineProcessor.class})
public final class ExampleCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    private final String pluginId;
    @NotNull
    private final Collection<CliOption> pluginOptions;

    public ExampleCommandLineProcessor() {
        this.pluginId = "ktorfitPlugin";
        Object[] objectArray = new CliOption[]{new CliOption("enabled", "<true|false>", "whether to enable the plugin or not", false, false, 24, null), new CliOption("logging", "<true|false>", "whether to enable logging", false, false, 24, null)};
        this.pluginOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public Collection<CliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = option.getOptionName();
        if (Intrinsics.areEqual((Object)string, (Object)"enabled")) {
            configuration.put(ExampleCommandLineProcessorKt.getKEY_ENABLED(), (Object)Boolean.parseBoolean(value));
        } else if (Intrinsics.areEqual((Object)string, (Object)"logging")) {
            configuration.put(ExampleCommandLineProcessorKt.getKEY_LOGGING(), (Object)Boolean.parseBoolean(value));
        } else {
            configuration.put(ExampleCommandLineProcessorKt.getKEY_ENABLED(), (Object)true);
        }
    }
}

