/*
 * Decompiled with CFR 0.152.
 */
package de.jensklingenberg.cabret;

import de.jensklingenberg.cabret.Cabret;
import de.jensklingenberg.cabret.CommonLogger;
import de.jensklingenberg.cabret.LogData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004J1\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/jensklingenberg/cabret/LogHandler;", "", "()V", "logger", "Lde/jensklingenberg/cabret/Cabret$Logger;", "addLogger", "", "logReturn", "T", "tag", "", "returnObject", "logLevel", "executionTime", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "onLog", "msg", "removeLogger", "cabret-log"})
public final class LogHandler {
    @NotNull
    public static final LogHandler INSTANCE = new LogHandler();
    @NotNull
    private static Cabret.Logger logger = new CommonLogger();

    private LogHandler() {
    }

    public final void onLog(@NotNull String tag, @NotNull String msg, @NotNull String logLevel) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Cabret.LogLevel serv = Cabret.LogLevel.valueOf(logLevel);
        logger.log(new LogData(tag, msg, serv));
    }

    public final void addLogger(@NotNull Cabret.Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        LogHandler.logger = logger;
    }

    public final <T> T logReturn(@NotNull String tag, T returnObject, @NotNull String logLevel, @NotNull String executionTime) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)executionTime, (String)"executionTime");
        this.onLog(tag + ' ' + executionTime, String.valueOf(returnObject), logLevel);
        return returnObject;
    }

    public final void removeLogger() {
        logger = new CommonLogger();
    }
}

