/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.commons.csv;

import de.jcup.commons.csv.CSVConstants;
import de.jcup.commons.csv.CSVLineSplitter;
import de.jcup.commons.csv.CSVModel;

public class CSVParser {
    private char delimiter = (char)59;
    private CSVConstants.LineEnding lineEnding = CSVConstants.DEFAULT_LINE_ENDING;
    private boolean cellAutoTrimmingEnabled = true;

    public void setCellAutoTrimmingEnabled(boolean cellAutoTrimmingEnabled) {
        this.cellAutoTrimmingEnabled = cellAutoTrimmingEnabled;
    }

    public boolean isCellAutoTrimmingEnabled() {
        return this.cellAutoTrimmingEnabled;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        if (delimiter == '\"') {
            throw new IllegalArgumentException("A delimiter \" is not allowed because it is used to escape strings!");
        }
        this.delimiter = delimiter;
    }

    public CSVConstants.LineEnding getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(CSVConstants.LineEnding lineEnding) {
        this.lineEnding = lineEnding;
    }

    public CSVModel parse(String csv, boolean withHeadline) throws CSVParseException {
        if (csv == null) {
            throw new IllegalArgumentException("csv may not be null");
        }
        if (this.lineEnding == null) {
            throw new IllegalArgumentException("lineEnding may not be null");
        }
        CSVModelBuildContext context = new CSVModelBuildContext();
        context.withHeadline = withHeadline;
        context.delimiter = String.valueOf(this.delimiter);
        context.lineSplitter = new CSVLineSplitter(this.delimiter);
        String[] lines = csv.split(this.lineEnding.getChars());
        CSVModel model = this.buildModel(context, lines);
        model.setDelimiter(this.delimiter);
        model.setLineEnding(this.lineEnding);
        return model;
    }

    private CSVModel buildEmptyModel() {
        return new CSVModel(new String[0]);
    }

    private CSVModel buildModel(CSVModelBuildContext context, String[] lines) throws CSVParseException {
        for (String line : lines) {
            this.buildLine(context, line);
            ++context.currentLineNumber;
        }
        if (context.model == null) {
            context.model = this.buildEmptyModel();
        }
        return context.model;
    }

    private void buildLine(CSVModelBuildContext context, String line) throws CSVParseException {
        if (line.isBlank()) {
            return;
        }
        String[] cells = context.lineSplitter.splitLine(line);
        this.autoTrimCellsIfEnabled(cells);
        if (context.currentLineNumber == 0) {
            context.firstLineColumnCount = cells.length;
        } else {
            this.assertSameColumnSizeAsAtFirstLine(context.firstLineColumnCount, context.currentLineNumber, cells);
        }
        boolean addAsRow = this.handleHeaders(context, cells);
        if (addAsRow) {
            CSVModel.CSVRow row = context.model.addRow();
            int index = 0;
            for (String columnName : context.model.getColumnNames()) {
                row.set(columnName, cells[index]);
                ++index;
            }
        }
    }

    private void autoTrimCellsIfEnabled(String[] cells) {
        if (!this.cellAutoTrimmingEnabled) {
            return;
        }
        for (int i = 0; i < cells.length; ++i) {
            String value = cells[i];
            if (value == null) continue;
            cells[i] = value.trim();
        }
    }

    private boolean handleHeaders(CSVModelBuildContext context, String[] cells) {
        boolean addAsRow = true;
        if (context.currentLineNumber == 0) {
            if (context.withHeadline) {
                context.model = new CSVModel(cells);
                addAsRow = false;
            } else {
                String[] syntheticColNames = new String[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    syntheticColNames[i] = "col" + i;
                }
                context.model = new CSVModel(syntheticColNames);
            }
        }
        return addAsRow;
    }

    private void assertSameColumnSizeAsAtFirstLine(int amountOfColumns, int currentLineNumber, String[] cells) throws CSVParseException {
        if (cells.length != amountOfColumns) {
            throw new CSVParseException("In first line we have " + amountOfColumns + ", but line: " + currentLineNumber + " has: " + cells.length, currentLineNumber);
        }
    }

    class CSVModelBuildContext {
        private CSVLineSplitter lineSplitter;
        private CSVModel model;
        private int currentLineNumber = 0;
        public boolean withHeadline;
        public String delimiter;
        public int firstLineColumnCount;

        CSVModelBuildContext() {
        }
    }

    public class CSVParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int line;
        private int column;

        public CSVParseException(String message) {
            this(message, 0);
        }

        public CSVParseException(String message, int line) {
            this(message, line, 0);
        }

        public CSVParseException(String message, int line, int column) {
            super(message);
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

