/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.commons.csv;

import de.jcup.commons.csv.CSVConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CSVModel {
    private char delimiter = (char)59;
    private CSVConstants.LineEnding lineEnding = CSVConstants.DEFAULT_LINE_ENDING;
    private List<String> columnNames = new ArrayList<String>();
    private List<CSVRow> rows = new ArrayList<CSVRow>();

    public CSVModel(String ... columnNames) {
        this.columnNames.addAll(Arrays.asList(columnNames));
    }

    public void setLineEnding(CSVConstants.LineEnding lineEnding) {
        if (lineEnding == null) {
            lineEnding = CSVConstants.DEFAULT_LINE_ENDING;
        }
        this.lineEnding = lineEnding;
    }

    public CSVConstants.LineEnding getLineEnding() {
        return this.lineEnding;
    }

    public void setDelimiter(char delimiter) {
        if (delimiter == '\"') {
            throw new IllegalArgumentException("A delimiter \" is not allowed because it is used to escape strings!");
        }
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getCellValue(String columnName, int rowIndex) {
        CSVRow row = this.assertRowForRowIndex(rowIndex);
        return row.getCellValue(columnName);
    }

    public CSVRow getRow(int rowIndex) {
        return this.assertRowForRowIndex(rowIndex);
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public CSVRow addRow() {
        CSVRow row = new CSVRow();
        this.rows.add(row);
        return row;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String toCSVString() {
        return this.toCSVString(true);
    }

    public String toCSVString(boolean withHeader) {
        StringBuilder sb = new StringBuilder();
        if (withHeader) {
            Iterator<String> it = this.columnNames.iterator();
            while (it.hasNext()) {
                String columnName = it.next();
                sb.append(this.escapedCellIfNecessary(columnName));
                if (!it.hasNext()) continue;
                sb.append(this.delimiter);
            }
            sb.append(this.lineEnding.getChars());
        }
        for (CSVRow row : this.rows) {
            int length = row.cells.length;
            int lastColumnWithDelimiter = length - 1;
            for (int i = 0; i < length; ++i) {
                String cell = this.escapedCellIfNecessary(row.cells[i]);
                sb.append(cell);
                if (i == lastColumnWithDelimiter) continue;
                sb.append(this.delimiter);
            }
            sb.append(this.lineEnding.getChars());
        }
        return sb.toString();
    }

    private String escapedCellIfNecessary(String cell) {
        if (cell.contains(String.valueOf(this.delimiter))) {
            return "\"" + cell + "\"";
        }
        return cell;
    }

    private CSVRow assertRowForRowIndex(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new IndexOutOfBoundsException(rowIndex);
        }
        return this.rows.get(rowIndex);
    }

    private int assetColumnIndexForName(String columnName) {
        int index = this.columnNames.indexOf(columnName);
        if (index == -1) {
            throw new IllegalArgumentException("The column: " + columnName + " is not wellknown! Accepted CSV columns are:" + this.columnNames);
        }
        return index;
    }

    public class CSVRow {
        private String[] cells;

        private CSVRow() {
            this.cells = new String[CSVModel.this.columnNames.size()];
        }

        public String getCellValue(String columnName) {
            int index = CSVModel.this.assetColumnIndexForName(columnName);
            return this.cells[index];
        }

        public CSVRow set(String columnName, Object cellData) {
            return this.set(columnName, String.valueOf(cellData));
        }

        public CSVRow set(String columnName, double cellData) {
            return this.set(columnName, String.valueOf(cellData));
        }

        public CSVRow set(String columnName, long cellData) {
            return this.set(columnName, String.valueOf(cellData));
        }

        public CSVRow set(String columnName, String cellData) {
            int index = CSVModel.this.assetColumnIndexForName(columnName);
            this.cells[index] = cellData;
            return this;
        }
    }
}

