/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.commons.csv;

import de.jcup.commons.csv.CSVConstants;
import java.util.ArrayList;

public class CSVLineSplitter {
    private char delimiter;

    CSVLineSplitter(char delimiter) {
        this.delimiter = delimiter;
    }

    String[] splitLine(String line) {
        ArrayList<String> cellList = new ArrayList<String>(line.length() / 2);
        char[] charArray = line.toCharArray();
        ParseState state = ParseState.NORMAL;
        StringBuilder sb = new StringBuilder();
        char charBefore = '-';
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\"') {
                if (ParseState.NORMAL.equals((Object)state)) {
                    state = ParseState.STRING_ESCAPING_ACTIVE;
                } else if (ParseState.STRING_ESCAPING_ACTIVE.equals((Object)state)) {
                    if (charBefore == '\"') {
                        sb.append(CSVConstants.ESCAPE_CHAR_AS_STRING);
                    }
                    state = ParseState.NORMAL;
                }
            } else if (c == this.delimiter) {
                if (ParseState.STRING_ESCAPING_ACTIVE.equals((Object)state)) {
                    sb.append(c);
                } else {
                    String string = sb.toString();
                    cellList.add(string);
                    sb = new StringBuilder();
                    state = ParseState.NORMAL;
                }
            } else {
                sb.append(c);
            }
            charBefore = c;
        }
        if (!sb.isEmpty()) {
            String string = sb.toString();
            cellList.add(string);
        }
        return cellList.toArray(new String[cellList.size()]);
    }

    private static enum ParseState {
        STRING_ESCAPING_ACTIVE,
        NORMAL;

    }
}

