/*
 * Decompiled with CFR 0.152.
 */
package de.jbellmann.rwds.initializers;

import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public class ReadWritePostgresInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadWritePostgresInitializer.class);
    static Network network = Network.newNetwork();
    public static final String POSTGRES = "postgres";
    static GenericContainer<?> writePostgres = new GenericContainer(DockerImageName.parse((String)"bitnami/postgresql:14")).withEnv(Map.of("POSTGRESQL_REPLICATION_MODE", "master", "POSTGRESQL_REPLICATION_USER", "repl_user", "POSTGRESQL_REPLICATION_PASSWORD", "repl_password", "POSTGRESQL_USERNAME", "postgres", "POSTGRESQL_PASSWORD", "postgres", "POSTGRESQL_DATABASE", "postgres", "ALLOW_EMPTY_PASSWORD", "yes")).withExposedPorts(new Integer[]{5432}).withNetwork(network).withNetworkAliases(new String[]{"postgresql-write"});
    static GenericContainer<?> readPostgres = new GenericContainer(DockerImageName.parse((String)"bitnami/postgresql:14")).withEnv(Map.of("POSTGRESQL_REPLICATION_MODE", "slave", "POSTGRESQL_REPLICATION_USER", "repl_user", "POSTGRESQL_REPLICATION_PASSWORD", "repl_password", "POSTGRESQL_MASTER_HOST", "postgresql-write", "POSTGRESQL_MASTER_PORT", "5432", "POSTGRESQL_USERNAME", "postgres", "POSTGRESQL_PASSWORD", "postgres", "ALLOW_EMPTY_PASSWORD", "yes")).withExposedPorts(new Integer[]{5432}).withNetwork(network).withNetworkAliases(new String[]{"postgresql-read"});

    public static Map<String, String> getProperties() {
        Startables.deepStart(Stream.of(writePostgres, readPostgres)).join();
        String urlTemplate = "jdbc:postgresql://localhost:%s/postgres";
        return Map.of("rwds.datasource.write.url", String.format(urlTemplate, writePostgres.getMappedPort(5432)), "rwds.datasource.write.username", POSTGRES, "rwds.datasource.write.password", POSTGRES, "rwds.datasource.read.url", String.format(urlTemplate, readPostgres.getMappedPort(5432)), "rwds.datasource.read.username", POSTGRES, "rwds.datasource.read.password", POSTGRES);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        env.getPropertySources().addFirst((PropertySource)new MapPropertySource("readWritePostgresInitializer", ReadWritePostgresInitializer.getProperties()));
    }
}

