/*
 * Decompiled with CFR 0.152.
 */
package de.jbellmann.rwds;

import de.jbellmann.rwds.CurrentTransactionType;
import de.jbellmann.rwds.TransactionType;
import java.util.HashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class ReadWriteDataSource
extends AbstractRoutingDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadWriteDataSource.class);
    protected static final CurrentTransactionType CURRENT_TRANSACTION_TYPE = new CurrentTransactionType();

    public ReadWriteDataSource(DataSource writeDataSource, DataSource readDataSource) {
        HashMap<TransactionType, DataSource> dataSourceMap = new HashMap<TransactionType, DataSource>(2);
        dataSourceMap.put(TransactionType.READ, readDataSource);
        dataSourceMap.put(TransactionType.WRITE, writeDataSource);
        super.setTargetDataSources(dataSourceMap);
        super.setDefaultTargetDataSource((Object)writeDataSource);
    }

    static void setReadOnlyDataSource(boolean isReadOnly) {
        log.debug("set datasource read-only : {}", (Object)isReadOnly);
        CURRENT_TRANSACTION_TYPE.set(isReadOnly ? TransactionType.READ : TransactionType.WRITE);
    }

    protected Object determineCurrentLookupKey() {
        TransactionType dataSourceTransactionType = (TransactionType)((Object)CURRENT_TRANSACTION_TYPE.get());
        log.debug("Returning datasource lookup key : {}", (Object)dataSourceTransactionType);
        return dataSourceTransactionType;
    }
}

