/*
 * Decompiled with CFR 0.152.
 */
package de.jbellmann.rwds;

import java.util.HashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class ReadWriteDataSource
extends AbstractRoutingDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadWriteDataSource.class);
    protected static final ThreadLocal<Type> currentDataSource = new ThreadLocal();

    public ReadWriteDataSource(DataSource writeDataSource, DataSource readDataSource) {
        HashMap<Type, DataSource> dataSourceMap = new HashMap<Type, DataSource>(2);
        dataSourceMap.put(Type.READ, readDataSource);
        dataSourceMap.put(Type.WRITE, writeDataSource);
        super.setTargetDataSources(dataSourceMap);
        super.setDefaultTargetDataSource((Object)writeDataSource);
    }

    static void setReadOnlyDataSource(boolean isReadOnly) {
        log.debug("set datasource read-only : {}", (Object)isReadOnly);
        currentDataSource.set(isReadOnly ? Type.READ : Type.WRITE);
    }

    protected Object determineCurrentLookupKey() {
        Type dataSourceType = currentDataSource.get();
        log.debug("Returning datasource lookup key : {}", (Object)dataSourceType);
        return dataSourceType;
    }

    protected static enum Type {
        READ,
        WRITE;

    }
}

