/*
 * Decompiled with CFR 0.152.
 */
package de.jbellmann.rwds;

import de.jbellmann.rwds.ReadWriteDataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class ReadWriteAwareTransactionManager
implements PlatformTransactionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadWriteAwareTransactionManager.class);
    private final PlatformTransactionManager delegate;

    public ReadWriteAwareTransactionManager(PlatformTransactionManager delegate) {
        this.delegate = delegate;
    }

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        ReadWriteDataSource.setReadOnlyDataSource(definition.isReadOnly());
        log.debug("Set by transaction : {}", (Object)(definition.getName() != null ? definition.getName() : "UNKNOWN"));
        return this.delegate.getTransaction(definition);
    }

    public void commit(TransactionStatus status) throws TransactionException {
        log.trace("Committing transaction : {}", (Object)status);
        this.delegate.commit(status);
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        log.trace("Rollback transaction : {}", (Object)status);
        this.delegate.rollback(status);
    }
}

