/*
 * Decompiled with CFR 0.152.
 */
package de.jbellmann.rwds.autoconfigure;

import de.jbellmann.rwds.autoconfigure.RwdsProperties;
import de.jbellmann.rwds.autoconfigure.conditions.ConditionalOnReadWriteDataSourceConfigProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.transaction.PlatformTransactionManagerCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnReadWriteDataSourceConfigProperties
@EnableConfigurationProperties(value={RwdsProperties.class})
class TransactionManagerCustomizersConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionManagerCustomizersConfiguration.class);

    TransactionManagerCustomizersConfiguration() {
    }

    @Bean
    PlatformTransactionManagerCustomizer<AbstractPlatformTransactionManager> setValidateTransaction(RwdsProperties rwdsProperties) {
        log.info("Set 'validateExistingTransaction' to '{}' via customizer ...", (Object)rwdsProperties.getTransactionManagerCustomizations().isValidateExistingTransaction());
        return transactionManager -> transactionManager.setValidateExistingTransaction(rwdsProperties.getTransactionManagerCustomizations().isValidateExistingTransaction());
    }

    @Bean
    PlatformTransactionManagerCustomizer<AbstractPlatformTransactionManager> setNestedTransactionAllowed(RwdsProperties rwdsProperties) {
        log.info("Set 'nestedTransactionAllowed' to '{}' via customizer ...", (Object)rwdsProperties.getTransactionManagerCustomizations().isNestedTransactionAllowed());
        return transactionManager -> transactionManager.setNestedTransactionAllowed(rwdsProperties.getTransactionManagerCustomizations().isNestedTransactionAllowed());
    }

    @Bean
    PlatformTransactionManagerCustomizer<AbstractPlatformTransactionManager> setFailEarlyOnGlobalRollbackOnly(RwdsProperties rwdsProperties) {
        log.info("Set 'failEarlyOnGlobalRollbackOnly' to '{}' via customizer ...", (Object)rwdsProperties.getTransactionManagerCustomizations().isFailEarlyOnGlobalRollbackOnly());
        return transactionManager -> transactionManager.setFailEarlyOnGlobalRollbackOnly(rwdsProperties.getTransactionManagerCustomizations().isFailEarlyOnGlobalRollbackOnly());
    }

    @Bean
    PlatformTransactionManagerCustomizer<AbstractPlatformTransactionManager> setRollbackOnCommitFailure(RwdsProperties rwdsProperties) {
        log.info("Set 'rollbackOnCommitFailure' to '{}' via customizer ...", (Object)rwdsProperties.getTransactionManagerCustomizations().isRollbackOnCommitFailure());
        return transactionManager -> transactionManager.setRollbackOnCommitFailure(rwdsProperties.getTransactionManagerCustomizations().isRollbackOnCommitFailure());
    }

    @Bean
    PlatformTransactionManagerCustomizer<AbstractPlatformTransactionManager> setglobalRollbackOnParticipationFailure(RwdsProperties rwdsProperties) {
        log.info("Set 'globalRollbackOnParticipationFailure' to '{}' via customizer ...", (Object)rwdsProperties.getTransactionManagerCustomizations().isGlobalRollbackOnParticipationFailure());
        return transactionManager -> transactionManager.setGlobalRollbackOnParticipationFailure(rwdsProperties.getTransactionManagerCustomizations().isGlobalRollbackOnParticipationFailure());
    }
}

