/*
 * Decompiled with CFR 0.152.
 */
package de.jbellmann.rwds.autoconfigure;

import com.zaxxer.hikari.HikariDataSource;
import de.jbellmann.rwds.ReadWriteDataSource;
import de.jbellmann.rwds.autoconfigure.conditions.ConditionalOnReadWriteDataSourceConfigProperties;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnReadWriteDataSourceConfigProperties
public class ReadWriteDataSourceConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadWriteDataSourceConfiguration.class);
    public static final String PROPERTY_RWDS_DS_WRITE = "rwds.datasource.write";
    public static final String PROPERTY_RWDS_DS_READ = "rwds.datasource.read";
    public static final String PROPERTY_RWDS_DS_WRITE_CONFIGURATION = "rwds.datasource.write.configuration";
    public static final String PROPERTY_RWDS_DS_READ_CONFIGURATION = "rwds.datasource.read.configuration";
    public static final String RWDS_WRITE_DATA_SOURCE_PROPERTIES_BEAN = "rwdsWriteDataSourceProperties";
    public static final String RWDS_READ_DATA_SOURCE_PROPERTIES_BEAN = "rwdsReadDataSourceProperties";
    public static final String RWDS_WRITE_DATA_SOURCE_BEAN = "rwdsWriteDataSource";
    public static final String RWDS_READ_DATA_SOURCE_BEAN = "rwdsReadDataSource";
    public static final String RWDS_DATA_SOURCE_BEAN = "rwdsDataSource";

    @Primary
    @Bean(name={"rwdsWriteDataSourceProperties"})
    @ConfigurationProperties(value="rwds.datasource.write")
    public DataSourceProperties writeDataSourceProperties() {
        log.debug("Load WriteDataSourceProperties ...");
        return new DataSourceProperties();
    }

    @Bean(name={"rwdsReadDataSourceProperties"})
    @ConfigurationProperties(value="rwds.datasource.read")
    public DataSourceProperties readDataSourceProperties() {
        log.debug("Load ReadDataSourceProperties ...");
        return new DataSourceProperties();
    }

    @Bean(name={"rwdsWriteDataSource"})
    @ConfigurationProperties(value="rwds.datasource.write.configuration")
    public HikariDataSource writeDataSource(@Qualifier(value="rwdsWriteDataSourceProperties") DataSourceProperties writeDataSourceProperties) {
        log.debug("Create WriteDataSource ...");
        return (HikariDataSource)writeDataSourceProperties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
    }

    @Bean(name={"rwdsReadDataSource"})
    @ConfigurationProperties(value="rwds.datasource.read.configuration")
    public HikariDataSource readDataSource(@Qualifier(value="rwdsReadDataSourceProperties") DataSourceProperties readDataSourceProperties) {
        log.debug("Create ReadDataSource ...");
        return (HikariDataSource)readDataSourceProperties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
    }

    @Primary
    @Bean(name={"rwdsDataSource"})
    public DataSource routingDataSource(@Qualifier(value="rwdsWriteDataSource") DataSource writeDataSource, @Qualifier(value="rwdsReadDataSource") DataSource readDataSource) {
        log.debug("Create ReadWriteDataSource ...");
        return new ReadWriteDataSource(writeDataSource, readDataSource);
    }
}

