/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol.tags;

public enum ValueTags {
    UNSUPPORTED(16),
    RESERVED_FOR_DEFAULT(17),
    UNKNOWN(18),
    NO_VALUE(19),
    RESERVED_FOR_OUT_OF_BAND_VALUES(31),
    GENERIC_INTEGER(32),
    INTEGER(33),
    BOOLEAN(34),
    ENUM(35),
    RESERVED_FOR_INTEGER_TYPE(47),
    UNSPECIFIED_OCTET_STRING(48),
    DATE_TIME(49),
    RESOLUTION(50),
    RANGE_OF_INTEGER(51),
    RESERVED_34(52),
    TEXT_WITH_LANGUAGE(53),
    NAME_WITH_LANGUAGE(54),
    RESERVED_FOR_OCTET_STRING_TYPE(95),
    RESERVED_40(64),
    TEXT_WITHOUT_LANGUAGE(65),
    NAME_WITHOUT_LANGUAGE(66),
    RESERVED_43(67),
    KEYWORD(68),
    URI(69),
    URI_SCHEME(70),
    CHARSET(71),
    NATURAL_LANGUAGE(72),
    MIME_MEDIA_TYPE(73),
    RESERVED_FOR_CHARACTER_STRING_TYPE(95),
    RESERVED_FOR_FUTURE_TYPE(255);

    private final byte value;

    private ValueTags(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean isIntegerValue() {
        return 32 <= this.value && this.value <= 47;
    }

    public boolean isCharacterStringValue() {
        return 64 <= this.value && this.value <= 79;
    }

    public static ValueTags of(int id) {
        for (ValueTags tag : ValueTags.values()) {
            if (id != tag.getValue()) continue;
            return tag;
        }
        throw new IllegalArgumentException("invalid id: " + id);
    }

    public static boolean isValid(int id) {
        return 16 <= id && id <= 255;
    }
}

