/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol.attr;

import j4cups.protocol.Binary;
import j4cups.protocol.attr.Attribute;
import j4cups.protocol.tags.DelimiterTags;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AttributeGroup
implements Binary {
    private final DelimiterTags beginTag;
    private final List<Attribute> attributes;

    public AttributeGroup(AttributeGroup other) {
        this(ByteBuffer.wrap(other.toByteArray()));
    }

    public AttributeGroup(DelimiterTags type) {
        this.beginTag = type;
        this.attributes = new ArrayList<Attribute>();
    }

    public AttributeGroup(ByteBuffer bytes) {
        this.beginTag = DelimiterTags.of(bytes.get());
        this.attributes = AttributeGroup.readAttributes(bytes);
    }

    private static List<Attribute> readAttributes(ByteBuffer buffer) {
        int pos;
        ArrayList<Attribute> values = new ArrayList<Attribute>();
        while (!(buffer.remaining() <= 4 || DelimiterTags.isValid(buffer.get(pos = buffer.position())) && buffer.getShort(pos + 1) != 0)) {
            values.add(new Attribute(buffer));
        }
        return values;
    }

    public DelimiterTags getBeginTag() {
        return this.beginTag;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        for (Attribute attr : this.attributes) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        throw new IllegalArgumentException("attribute '" + name + "' not found in " + this.attributes);
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("|");
        for (Attribute attr : this.getAttributes()) {
            buffer.append(attr.toString()).append('|');
        }
        return buffer.toString();
    }

    public String toLongString() {
        StringBuilder buffer = new StringBuilder("|");
        buffer.append(String.format("%02x", this.getBeginTag().getValue())).append('|');
        for (Attribute attr : this.getAttributes()) {
            buffer.append(attr.toLongString()).append('|');
        }
        return buffer.toString();
    }

    @Override
    public void writeBinaryTo(OutputStream ostream) throws IOException {
        DataOutputStream dos = new DataOutputStream(ostream);
        dos.writeByte(this.getBeginTag().getValue());
        for (Attribute attr : this.getAttributes()) {
            dos.write(attr.toByteArray());
        }
    }
}

