/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol;

public enum StatusCode {
    SUCCESSFUL_OK(0),
    SUCCESSFUL_OK_IGNORED_OR_SUBSTITUTED_ATTRIBUTES(1),
    SUCCESSFUL_OK_CONFLICTING_ATTRIBUTES(2),
    CLIENT_ERROR_BAD_REQUEST(1024),
    CLIENT_ERROR_FORBIDDEN(1025),
    CLIENT_ERROR_NOT_AUTHENTICATED(1026),
    CLIENT_ERROR_NOT_AUTHORIZED(1027),
    CLIENT_ERROR_NOT_POSSIBLE(1028),
    CLIENT_ERROR_TIMEOUT(1029),
    CLIENT_ERROR_NOT_FOUND(1030),
    CLIENT_ERRROR_GONE(1031),
    CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE(1032),
    CLIENT_ERROR_REQUEST_VALUE_TOO_LONG(1033),
    CLIENT_ERROR_DOCUMENT_FORMAT_NOT_SUPPORTED(1034),
    CLIENT_ERROR_ATTRIBUTES_OR_VALUES_NOT_SUPPORTED(1035),
    CLIENT_ERROR_URI_SCHEME_NOT_SUPPORTED(1036),
    CLIENT_ERROR_CHARSET_NOT_SUPPORTED(1037),
    CLIENT_ERROR_CONFLICTING_ATTRIBUTES(1038),
    CLIENT_ERROR_COMPRESSION_NOT_SUPPORTED(1039),
    CLIENT_ERROR_COMPRESSION_ERROR(1040),
    CLIENT_ERROR_DOCUMENT_FORMAT_ERROR(1041),
    CLIENT_ERROR_DOCUMENT_ACCESS_ERROR(1042),
    SERVER_ERROR_INTERNAL_ERROR(1280),
    SERVER_ERROR_OPERATION_NOT_SUPPORTED(1281),
    SERVER_ERROR_SERVICE_UNAVAILABLE(1282),
    SERVER_ERROR_VERSION_NOT_SUPPORTED(1283),
    SERVER_ERROR_DEVICE_ERROR(1284),
    SERVER_ERROR_TEMPORARY_ERROR(1285),
    SERVER_ERROR_NOT_ACCEPTING_JOBS(1286),
    SERVER_ERROR_BUSY(1287),
    SERVER_ERROR_JOB_CANCELED(1288),
    SERVER_ERROR_MULTIPLE_DOCUMENT_JOBS_NOT_SUPPORTED(1289);

    private final short code;

    private StatusCode(int value) {
        this.code = (short)value;
    }

    public short getCode() {
        return this.code;
    }

    public String toString() {
        return super.toString().toLowerCase().replaceAll("_", "-");
    }

    public static StatusCode of(int id) {
        for (StatusCode op : StatusCode.values()) {
            if (id != op.getCode()) continue;
            return op;
        }
        throw new IllegalArgumentException("invalid id: " + id);
    }
}

