/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol;

import j4cups.protocol.attr.Attribute;
import j4cups.protocol.attr.AttributeGroup;
import j4cups.protocol.tags.DelimiterTags;
import j4cups.protocol.tags.ValueTags;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIpp
implements Externalizable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIpp.class);
    protected static final Version DEFAULT_VERSION = new Version(2, 0);
    private transient Version version;
    private short opCode;
    private transient List<AttributeGroup> attributeGroups;
    private int requestId;
    private byte[] data;

    protected AbstractIpp() {
        this(new Version(2, 0), 0, 0, new ArrayList<AttributeGroup>(), new byte[0]);
    }

    protected AbstractIpp(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public AbstractIpp(ByteBuffer bytes) {
        this(new Version(bytes.get(), bytes.get()), bytes.getShort(), bytes.getInt(), AbstractIpp.readAttributeGroups(bytes), AbstractIpp.readData(bytes));
        LOG.debug("IPP package with {} received.", (Object)bytes);
        this.trace(bytes.array());
    }

    public AbstractIpp(Version version, short opCode, int requestId, List<AttributeGroup> groups) {
        this(version, opCode, requestId, groups, new byte[0]);
    }

    public AbstractIpp(Version version, short opCode, int requestId, List<AttributeGroup> groups, byte[] data) {
        this.version = version;
        this.opCode = opCode;
        this.requestId = requestId;
        this.attributeGroups = groups;
        this.data = data;
        AbstractIpp.fillAttributeGroups(groups);
    }

    private static void fillAttributeGroups(List<AttributeGroup> values) {
        ArrayList<DelimiterTags> requiredTags = new ArrayList<DelimiterTags>(Arrays.asList(DelimiterTags.OPERATION_ATTRIBUTES_TAG, DelimiterTags.JOB_ATTRIBUTES_TAG, DelimiterTags.PRINTER_ATTRIBUTES_TAG, DelimiterTags.UNSUPPORTED_ATTRIBUTES_TAG));
        for (AttributeGroup group : values) {
            DelimiterTags tag = group.getBeginTag();
            requiredTags.remove((Object)tag);
        }
        for (DelimiterTags tag : requiredTags) {
            AttributeGroup group = new AttributeGroup(tag);
            values.add(group);
            LOG.trace("Empty {} added.", (Object)group);
        }
    }

    private void trace(byte[] bytes) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(DatatypeConverter.printHexBinary((byte[])bytes));
            try {
                Path logDir = Paths.get(SystemUtils.getJavaIoTmpDir().toString(), "IPP");
                Files.createDirectories(logDir, new FileAttribute[0]);
                Path logFile = Paths.get(logDir.toString(), Long.toString(System.currentTimeMillis(), 36) + "-" + this.getClass().getSimpleName() + this.getRequestId() + this.getOpCodeAsString() + ".bin");
                Files.write(logFile, bytes, new OpenOption[0]);
                LOG.info("IPP package with {} bytes is recorded to '{}'.", (Object)bytes.length, (Object)logFile);
            }
            catch (IOException ioe) {
                LOG.debug("Cannot record {} bytes to temporary log file.", (Throwable)ioe);
                LOG.trace(DatatypeConverter.printHexBinary((byte[])bytes));
            }
        } else {
            LOG.debug("{}-{} {} received (use TRACE level to dump it).", new Object[]{this.getClass().getSimpleName(), this.requestId, this.getOpCodeAsString()});
        }
    }

    private static List<AttributeGroup> readAttributeGroups(ByteBuffer buffer) {
        int pos;
        ArrayList<AttributeGroup> values = new ArrayList<AttributeGroup>();
        while (buffer.remaining() > 4 && DelimiterTags.END_OF_ATTRIBUTES_TAG != DelimiterTags.of(buffer.get(pos = buffer.position()))) {
            values.add(new AttributeGroup(buffer));
        }
        return values;
    }

    private static byte[] readData(ByteBuffer buffer) {
        DelimiterTags endOfAttributeTag = DelimiterTags.of(buffer.get());
        LOG.trace("{} was read (and ignored).", (Object)endOfAttributeTag);
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setOpCode(short opCode) {
        this.opCode = opCode;
    }

    public short getOpCode() {
        return this.opCode;
    }

    protected abstract String getOpCodeAsString();

    public int getRequestId() {
        return this.requestId;
    }

    public List<AttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public AttributeGroup getAttributeGroup(DelimiterTags tag) {
        for (AttributeGroup group : this.getAttributeGroups()) {
            if (group.getBeginTag() != tag) continue;
            return group;
        }
        throw new IllegalArgumentException("attribute-group " + (Object)((Object)tag) + " not found");
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeGroup group : this.attributeGroups) {
            attributes.addAll(group.getAttributes());
        }
        return attributes;
    }

    public void setAttribute(String name, byte[] value) {
        try {
            Attribute attr = this.getAttribute(name);
            attr.setValue(value);
        }
        catch (IllegalArgumentException iae) {
            LOG.debug("Attribute '{}' will be inserted as 'unsupported/unknown', because not found in existing attributes.", (Object)name);
            LOG.trace("Details:", (Throwable)iae);
            this.setAttribute(Attribute.of(ValueTags.UNKNOWN, name, value), DelimiterTags.UNSUPPORTED_ATTRIBUTES_TAG);
        }
    }

    public void setAttribute(Attribute attr, DelimiterTags groupTag) {
        AttributeGroup group = this.getAttributeGroup(groupTag);
        group.addAttribute(attr);
    }

    public Attribute getAttribute(String name) {
        for (Attribute attr : this.getAttributes()) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        throw new IllegalArgumentException("no attribute '" + name + "' found");
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data.length > 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("|");
        buffer.append(this.getRequestId());
        for (Attribute attr : this.getAttributes()) {
            buffer.append("|");
            buffer.append(attr);
        }
        buffer.append("|");
        return this.buildString(buffer.toString());
    }

    public String toLongString() {
        StringBuilder attrs = new StringBuilder();
        for (AttributeGroup group : this.attributeGroups) {
            if (group.getAttributes().isEmpty()) continue;
            attrs.append('|').append(group.toLongString());
        }
        return this.buildString(attrs.substring(1));
    }

    private String buildString(String attrs) {
        String hex = "";
        if (this.hasData()) {
            hex = StringUtils.abbreviateMiddle((String)DatatypeConverter.printHexBinary((byte[])this.getData()), (String)"...", (int)100) + "|";
        }
        return "|" + this.getVersion() + "|" + this.getOpCodeAsString() + attrs + hex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray() {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            this.writeTo(byteStream);
            byteStream.flush();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("cannot dump package", ioe);
        }
    }

    private void writeTo(OutputStream ostream) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(ostream);){
            dos.write(this.version.toByteArray());
            dos.writeShort(this.getOpCode());
            dos.writeInt(this.getRequestId());
            for (AttributeGroup group : this.getAttributeGroups()) {
                if (group.getAttributes().isEmpty()) continue;
                dos.write(group.toByteArray());
            }
            dos.writeByte(DelimiterTags.END_OF_ATTRIBUTES_TAG.getValue());
            dos.write(this.getData());
            dos.flush();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.toByteArray());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = new Version(in.readByte(), in.readByte());
        this.opCode = in.readShort();
        this.requestId = in.readInt();
        try (ByteArrayOutputStream ostream = new ByteArrayOutputStream();){
            int x;
            while ((x = in.read()) >= 0) {
                ostream.write(x);
            }
            ostream.flush();
            ByteBuffer buffer = ByteBuffer.wrap(ostream.toByteArray());
            this.attributeGroups.addAll(AbstractIpp.readAttributeGroups(buffer));
            this.data = AbstractIpp.readData(buffer);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractIpp)) {
            return false;
        }
        AbstractIpp other = (AbstractIpp)obj;
        return Arrays.equals(this.toByteArray(), other.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getData()) + this.requestId + this.opCode;
    }

    public static class Version {
        private final byte[] bytes = new byte[2];

        public Version(byte major, byte minor) {
            this.bytes[0] = major;
            this.bytes[1] = minor;
        }

        public String toString() {
            return this.bytes[0] + "." + this.bytes[1];
        }

        public byte[] toByteArray() {
            return this.bytes;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.bytes});
        }
    }
}

