/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol.attr;

import j4cups.protocol.Binary;
import j4cups.protocol.tags.ValueTags;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;

public final class Attribute
implements Binary {
    private final AttributeWithOneValue value;
    private final List<AdditionalValue> additionalValues;

    public Attribute(ByteBuffer bytes) {
        this(new AttributeWithOneValue(bytes), Attribute.readAdditionalValues(bytes));
    }

    private Attribute(AttributeWithOneValue value) {
        this(value, new ArrayList<AdditionalValue>());
    }

    private Attribute(AttributeWithOneValue value, List<AdditionalValue> additionalValues) {
        this.value = value;
        this.additionalValues = additionalValues;
    }

    private static List<AdditionalValue> readAdditionalValues(ByteBuffer buffer) {
        int pos;
        ArrayList<AdditionalValue> values = new ArrayList<AdditionalValue>();
        while (buffer.remaining() > 4 && ValueTags.isValid(buffer.get(pos = buffer.position())) && buffer.getShort(pos + 1) == 0) {
            values.add(new AdditionalValue(buffer));
        }
        return values;
    }

    public static Attribute of(String name, int value) {
        return Attribute.of(ValueTags.INTEGER, name, value);
    }

    public static Attribute of(String name, URI value) {
        return Attribute.of(ValueTags.URI, name, value.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static Attribute of(String name, Charset value) {
        return Attribute.of(ValueTags.CHARSET, name, value.name().toLowerCase());
    }

    public static Attribute of(String name, Locale value) {
        return Attribute.of(ValueTags.NATURAL_LANGUAGE, name, value.getLanguage());
    }

    public static Attribute of(ValueTags tag, String name, int value) {
        byte[] bytes = new byte[4];
        ByteBuffer.wrap(bytes).putInt(value);
        return Attribute.of(ValueTags.INTEGER, name, bytes);
    }

    public static Attribute of(ValueTags tag, String name, String value) {
        return Attribute.of(ValueTags.CHARSET, name, value.getBytes(StandardCharsets.UTF_8));
    }

    public static Attribute of(ValueTags tag, String name, byte[] value) {
        AttributeWithOneValue attr = new AttributeWithOneValue(tag, name, value);
        return new Attribute(attr);
    }

    public ValueTags getValueTag() {
        return this.value.getValueTag();
    }

    public String getName() {
        return this.value.getName();
    }

    public byte[] getValue() {
        return this.value.getValue();
    }

    public String getStringValue() {
        return new String(this.getValue(), StandardCharsets.UTF_8);
    }

    public URI getUriValue() {
        return URI.create(this.getStringValue());
    }

    public boolean isMultiValue() {
        return !this.additionalValues.isEmpty();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getName());
        buffer.append("=");
        if (this.getValueTag().isCharacterStringValue()) {
            buffer.append(this.getStringValue());
        } else {
            buffer.append(DatatypeConverter.printHexBinary((byte[])this.getValue()));
        }
        if (!this.additionalValues.isEmpty()) {
            buffer.append(",...");
        }
        return buffer.toString();
    }

    public String toLongString() {
        StringBuilder buffer = new StringBuilder(this.getName());
        buffer.append("=");
        if (this.getValueTag().isCharacterStringValue()) {
            buffer.append(this.getStringValue());
        } else {
            buffer.append(new BigInteger(this.getValue()).toString(16));
        }
        for (AdditionalValue addValue : this.additionalValues) {
            buffer.append(',');
            if (this.getValueTag().isCharacterStringValue()) {
                buffer.append(addValue.getStringValue());
                continue;
            }
            buffer.append(DatatypeConverter.printHexBinary((byte[])addValue.getValue()));
        }
        return buffer.toString();
    }

    @Override
    public void writeBinaryTo(OutputStream ostream) throws IOException {
        DataOutputStream dos = new DataOutputStream(ostream);
        dos.write(this.value.toByteArray());
        for (AdditionalValue av : this.additionalValues) {
            dos.write(av.toByteArray());
        }
    }

    public static class AdditionalValue
    extends AttributeWithOneValue {
        public AdditionalValue(ByteBuffer bytes) {
            super(bytes);
        }
    }

    public static class AttributeWithOneValue {
        private final ValueTags valueTag;
        private final String name;
        private final byte[] value;

        public AttributeWithOneValue(ByteBuffer bytes) {
            this.valueTag = ValueTags.of(bytes.get());
            short nameLength = bytes.getShort();
            this.name = AttributeWithOneValue.readString(bytes, nameLength);
            short valueLength = bytes.getShort();
            this.value = AttributeWithOneValue.readBytes(bytes, valueLength);
        }

        public AttributeWithOneValue(ValueTags valueTag, String name, byte[] value) {
            this.valueTag = valueTag;
            this.name = name;
            this.value = value;
        }

        private static String readString(ByteBuffer buffer, short length) {
            byte[] bytes = AttributeWithOneValue.readBytes(buffer, length);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        private static byte[] readBytes(ByteBuffer buffer, short length) {
            byte[] value = new byte[length];
            for (int i = 0; i < length; ++i) {
                value[i] = buffer.get();
            }
            return value;
        }

        public ValueTags getValueTag() {
            return this.valueTag;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String getStringValue() {
            return new String(this.getValue(), StandardCharsets.UTF_8);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] toByteArray() {
            try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
                this.writeTo(byteStream);
                byteStream.flush();
                byte[] byArray = byteStream.toByteArray();
                return byArray;
            }
            catch (IOException ioe) {
                throw new IllegalStateException("cannot dump attribute", ioe);
            }
        }

        private void writeTo(OutputStream ostream) throws IOException {
            DataOutputStream dos = new DataOutputStream(ostream);
            dos.writeByte(this.getValueTag().getValue());
            dos.writeShort(this.getName().length());
            dos.write(this.getName().getBytes(StandardCharsets.UTF_8));
            dos.writeShort(this.getValue().length);
            dos.write(this.getValue());
        }
    }
}

