/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol;

import j4cups.protocol.AbstractIpp;
import j4cups.protocol.IppRequest;
import j4cups.protocol.StatusCode;
import j4cups.protocol.attr.Attribute;
import j4cups.protocol.attr.AttributeGroup;
import j4cups.protocol.enums.JobState;
import j4cups.protocol.tags.DelimiterTags;
import j4cups.protocol.tags.ValueTags;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IppResponse
extends AbstractIpp {
    private static final Logger LOG = LoggerFactory.getLogger(IppResponse.class);

    public IppResponse(IppRequest request) {
        super(DEFAULT_VERSION, StatusCode.SUCCESSFUL_OK.getCode(), request.getRequestId(), IppResponse.fillAttributesGroupsFor(request));
    }

    private static List<AttributeGroup> fillAttributesGroupsFor(IppRequest request) {
        ArrayList<AttributeGroup> groups = new ArrayList<AttributeGroup>();
        switch (request.getOperation()) {
            case PRINT_JOB: {
                groups.add(IppResponse.createPrintJobOperationAttributes());
                groups.add(IppResponse.createPrintJobJobAttributes(request));
            }
        }
        return groups;
    }

    private static AttributeGroup createPrintJobOperationAttributes() {
        AttributeGroup group = new AttributeGroup(DelimiterTags.OPERATIONS_ATTRIBUTES_TAG);
        group.addAttribute(Attribute.of("attributes-charset", StandardCharsets.UTF_8));
        group.addAttribute(Attribute.of("attributes-natural-language", Locale.getDefault()));
        return group;
    }

    private static AttributeGroup createPrintJobJobAttributes(IppRequest request) {
        AttributeGroup group = new AttributeGroup(DelimiterTags.JOB_ATTRIBUTES_TAG);
        int jobId = IppResponse.parseInt(request.getAttribute("job-name").getStringValue());
        URI jobUri = URI.create(request.getAttribute("printer-uri").getUriValue() + "/" + jobId);
        group.addAttribute(Attribute.of("job-id", jobId));
        group.addAttribute(Attribute.of("job-uri", jobUri));
        group.addAttribute(Attribute.of(ValueTags.ENUM, "job-state", JobState.COMPLETED.getState()));
        return group;
    }

    private static int parseInt(String value) {
        String number = StringUtils.substringBefore((String)value, (String)" ");
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            LOG.warn("No number in '{}' detected - will return 0:", (Throwable)ex);
            return 0;
        }
    }

    public StatusCode getStatusCode() {
        return StatusCode.of(super.getOpCode());
    }

    @Override
    protected String getOpCodeAsString() {
        return this.getStatusCode().toString();
    }
}

