/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol;

import j4cups.protocol.attr.Attribute;
import j4cups.protocol.attr.AttributeGroup;
import j4cups.protocol.tags.DelimiterTags;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIpp {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIpp.class);
    protected static final Version DEFAULT_VERSION = new Version(2, 0);
    private final Version version;
    private final short opCode;
    private final List<AttributeGroup> attributeGroups;
    private final int requestId;
    private final byte[] data;

    protected AbstractIpp(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public AbstractIpp(ByteBuffer bytes) {
        this(new Version(bytes.get(), bytes.get()), bytes.getShort(), bytes.getInt(), AbstractIpp.readAttributeGroups(bytes), AbstractIpp.readData(bytes));
        LOG.debug("IPP package with {} received.", (Object)bytes);
        this.trace(bytes.array());
    }

    public AbstractIpp(Version version, short opCode, int requestId, List<AttributeGroup> groups) {
        this(version, opCode, requestId, groups, new byte[0]);
    }

    public AbstractIpp(Version version, short opCode, int requestId, List<AttributeGroup> groups, byte[] data) {
        this.version = version;
        this.opCode = opCode;
        this.requestId = requestId;
        this.attributeGroups = groups;
        this.data = data;
    }

    private void trace(byte[] bytes) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(DatatypeConverter.printHexBinary((byte[])bytes));
            try {
                Path logDir = Paths.get(SystemUtils.getJavaIoTmpDir().toString(), "IPP");
                Files.createDirectories(logDir, new FileAttribute[0]);
                Path logFile = Paths.get(logDir.toString(), Long.toString(System.currentTimeMillis(), 36) + "-" + this.getClass().getSimpleName() + this.getRequestId() + this.getOpCodeAsString() + ".bin");
                Files.write(logFile, bytes, new OpenOption[0]);
                LOG.info("IPP package with {} bytes is recorded to '{}'.", (Object)bytes.length, (Object)logFile);
            }
            catch (IOException ioe) {
                LOG.debug("Cannot record {} bytes to temporary log file.", (Throwable)ioe);
                LOG.trace(DatatypeConverter.printHexBinary((byte[])bytes));
            }
        } else {
            LOG.debug("{}-{} {} received (use TRACE level to dump it).", new Object[]{this.getClass().getSimpleName(), this.requestId, this.getOpCodeAsString()});
        }
    }

    private static List<AttributeGroup> readAttributeGroups(ByteBuffer buffer) {
        int pos;
        ArrayList<AttributeGroup> values = new ArrayList<AttributeGroup>();
        while (buffer.remaining() > 4 && DelimiterTags.END_OF_ATTRIBUTES_TAG != DelimiterTags.of(buffer.get(pos = buffer.position()))) {
            values.add(new AttributeGroup(buffer));
        }
        return values;
    }

    private static byte[] readData(ByteBuffer buffer) {
        DelimiterTags endOfAttributeTag = DelimiterTags.of(buffer.get());
        LOG.trace("{} was read (and ignored).", (Object)endOfAttributeTag);
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public Version getVersion() {
        return this.version;
    }

    public short getOpCode() {
        return this.opCode;
    }

    protected abstract String getOpCodeAsString();

    public int getRequestId() {
        return this.requestId;
    }

    public List<AttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public List<Attribute> getAttributeGroups(DelimiterTags tag) {
        for (AttributeGroup group : this.getAttributeGroups()) {
            if (group.getBeginTag() != tag) continue;
            return group.getAttributes();
        }
        LOG.debug("Attribute-Group '{}' not found.", (Object)tag);
        return new ArrayList<Attribute>();
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeGroup group : this.attributeGroups) {
            attributes.addAll(group.getAttributes());
        }
        return attributes;
    }

    public Attribute getAttribute(String name) {
        for (Attribute attr : this.getAttributes()) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        throw new IllegalArgumentException("no attribute '" + name + "' found");
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data.length > 0;
    }

    public String toString() {
        String attrs = "|" + this.getRequestId() + "|...(" + this.getAttributes().size() + " attributes)...|";
        return this.buildString(attrs);
    }

    public String toLongString() {
        StringBuilder attrs = new StringBuilder();
        for (AttributeGroup group : this.attributeGroups) {
            attrs.append('|').append(group.toLongString());
        }
        return this.buildString(attrs.substring(1));
    }

    private String buildString(String attrs) {
        String hex = "";
        if (this.hasData()) {
            hex = StringUtils.abbreviateMiddle((String)DatatypeConverter.printHexBinary((byte[])this.getData()), (String)"...", (int)100) + "|";
        }
        return "|" + this.getVersion() + "|" + this.getOpCodeAsString() + attrs + hex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray() {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            this.writeTo(byteStream);
            byteStream.flush();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("cannot dump package", ioe);
        }
    }

    private void writeTo(OutputStream ostream) throws IOException {
        DataOutputStream dos = new DataOutputStream(ostream);
        dos.write(this.version.toByteArray());
        dos.writeShort(this.getOpCode());
        dos.writeInt(this.getRequestId());
        for (AttributeGroup group : this.getAttributeGroups()) {
            dos.write(group.toByteArray());
        }
        dos.writeByte(DelimiterTags.END_OF_ATTRIBUTES_TAG.getValue());
        dos.write(this.getData());
    }

    public static class Version {
        private final byte[] bytes = new byte[2];

        public Version(byte major, byte minor) {
            this.bytes[0] = major;
            this.bytes[1] = minor;
        }

        public String toString() {
            return this.bytes[0] + "." + this.bytes[1];
        }

        public byte[] toByteArray() {
            return this.bytes;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.bytes});
        }
    }
}

