/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol.attr;

import j4cups.protocol.tags.ValueTags;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Attribute {
    private final AttributeWithOneValue value;
    private final List<AdditionalValue> additionalValues;

    public Attribute(ByteBuffer bytes) {
        this.value = new AttributeWithOneValue(bytes);
        this.additionalValues = Attribute.readAdditionalValues(bytes);
    }

    private static List<AdditionalValue> readAdditionalValues(ByteBuffer buffer) {
        int pos;
        ArrayList<AdditionalValue> values = new ArrayList<AdditionalValue>();
        while (buffer.remaining() > 4 && ValueTags.isValid(buffer.get(pos = buffer.position())) && buffer.getShort(pos + 1) == 0) {
            values.add(new AdditionalValue(buffer));
        }
        return values;
    }

    public ValueTags getValueTag() {
        return this.value.getValueTag();
    }

    public String getName() {
        return this.value.getName();
    }

    public byte[] getValue() {
        return this.value.getValue();
    }

    public String getStringValue() {
        return new String(this.getValue(), StandardCharsets.UTF_8);
    }

    public boolean isMultiValue() {
        return !this.additionalValues.isEmpty();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getName());
        buffer.append("=");
        if (this.getValueTag().isCharacterStringValue()) {
            buffer.append(this.getStringValue());
        } else {
            buffer.append(new BigInteger(this.getValue()).toString(16));
        }
        if (!this.additionalValues.isEmpty()) {
            buffer.append(",...");
        }
        return buffer.toString();
    }

    public static class AdditionalValue
    extends AttributeWithOneValue {
        public AdditionalValue(ByteBuffer bytes) {
            super(bytes);
        }
    }

    public static class AttributeWithOneValue {
        private final ValueTags valueTag;
        private final String name;
        private final byte[] value;

        public AttributeWithOneValue(ByteBuffer bytes) {
            this.valueTag = ValueTags.of(bytes.get());
            short nameLength = bytes.getShort();
            this.name = AttributeWithOneValue.readString(bytes, nameLength);
            short valueLength = bytes.getShort();
            this.value = AttributeWithOneValue.readBytes(bytes, valueLength);
        }

        private static String readString(ByteBuffer buffer, short length) {
            byte[] bytes = AttributeWithOneValue.readBytes(buffer, length);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        private static byte[] readBytes(ByteBuffer buffer, short length) {
            byte[] value = new byte[length];
            for (int i = 0; i < length; ++i) {
                value[i] = buffer.get();
            }
            return value;
        }

        public ValueTags getValueTag() {
            return this.valueTag;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String getStringValue() {
            return new String(this.getValue(), StandardCharsets.UTF_8);
        }
    }
}

