/*
 * Decompiled with CFR 0.152.
 */
package j4cups.protocol;

import j4cups.protocol.IppOperations;
import j4cups.protocol.attr.Attribute;
import j4cups.protocol.attr.AttributeGroup;
import j4cups.protocol.tags.DelimiterTags;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IppRequest {
    private final String version;
    private final IppOperations operation;
    private final int requestId;
    private final List<AttributeGroup> attributeGroups;
    private final DelimiterTags endOfAttributeTag;
    private final byte[] data;

    public IppRequest(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public IppRequest(ByteBuffer bytes) {
        this.version = bytes.get() + "." + bytes.get();
        this.operation = IppOperations.of(bytes.getShort());
        this.requestId = bytes.getInt();
        this.attributeGroups = IppRequest.readAttributeGroups(bytes);
        this.endOfAttributeTag = DelimiterTags.of(bytes.get());
        this.data = IppRequest.readBytes(bytes);
    }

    private static List<AttributeGroup> readAttributeGroups(ByteBuffer buffer) {
        int pos;
        ArrayList<AttributeGroup> values = new ArrayList<AttributeGroup>();
        while (buffer.remaining() > 4 && DelimiterTags.END_OF_ATTRIBUTES_TAG != DelimiterTags.of(buffer.get(pos = buffer.position()))) {
            values.add(new AttributeGroup(buffer));
        }
        return values;
    }

    private static byte[] readBytes(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public String getVersion() {
        return this.version;
    }

    public IppOperations getOperation() {
        return this.operation;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public List<AttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeGroup group : this.attributeGroups) {
            attributes.addAll(group.getAttributes());
        }
        return attributes;
    }

    public Attribute getAttribute(String name) {
        for (Attribute attr : this.getAttributes()) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        throw new IllegalArgumentException("no attribute '" + name + "' found");
    }

    public byte[] getData() {
        return this.data;
    }
}

